/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.github.zafarkhaja.semver.Version;
import java.util.Iterator;
import java.util.Set;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.BrokerFilter;
import org.apache.pulsar.broker.loadbalance.BrokerFilterBadVersionException;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.policies.data.loadbalancer.BrokerData;
import org.apache.pulsar.policies.data.loadbalancer.BundleData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerVersionFilter
implements BrokerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerVersionFilter.class);

    public Version getLatestVersionNumber(Set<String> brokers, LoadData loadData) throws BrokerFilterBadVersionException {
        if (null == brokers) {
            throw new BrokerFilterBadVersionException("Unable to determine latest version since broker set was null");
        }
        if (brokers.size() == 0) {
            throw new BrokerFilterBadVersionException("Unable to determine latest version since broker set was empty");
        }
        if (null == loadData) {
            throw new BrokerFilterBadVersionException("Unable to determine latest version since loadData was null");
        }
        Version latestVersion = null;
        for (String broker : brokers) {
            BrokerData data = loadData.getBrokerData().get(broker);
            if (null == data) {
                LOG.warn("No broker data for broker [{}]; disabling PreferLaterVersions feature", (Object)broker);
                throw new BrokerFilterBadVersionException("No broker data for broker \"" + broker + "\"");
            }
            String brokerVersion = data.getLocalData().getBrokerVersionString();
            if (null == brokerVersion || brokerVersion.length() == 0) {
                LOG.warn("No version string in load report for broker [{}]; disabling PreferLaterVersions feature", (Object)broker);
                throw new BrokerFilterBadVersionException("No version string in load report for broker \"" + broker + "\"");
            }
            Version brokerVersionVersion = null;
            try {
                brokerVersionVersion = Version.valueOf((String)brokerVersion);
            }
            catch (Exception x) {
                LOG.warn("Invalid version string in load report for broker [{}]: [{}]; disabling PreferLaterVersions feature", (Object)broker, (Object)brokerVersion);
                throw new BrokerFilterBadVersionException("Invalid version string in load report for broker \"" + broker + "\": \"" + brokerVersion + "\")");
            }
            if (null == latestVersion) {
                latestVersion = brokerVersionVersion;
                continue;
            }
            if (Version.BUILD_AWARE_ORDER.compare(latestVersion, brokerVersionVersion) >= 0) continue;
            latestVersion = brokerVersionVersion;
        }
        if (null == latestVersion) {
            throw new BrokerFilterBadVersionException("Unable to determine latest broker version");
        }
        return latestVersion;
    }

    @Override
    public void filter(Set<String> brokers, BundleData bundleToAssign, LoadData loadData, ServiceConfiguration conf) throws BrokerFilterBadVersionException {
        if (!conf.isPreferLaterVersions()) {
            return;
        }
        Version latestVersion = null;
        try {
            latestVersion = this.getLatestVersionNumber(brokers, loadData);
            LOG.info("Latest broker version found was [{}]", (Object)latestVersion);
        }
        catch (Exception x) {
            LOG.warn("Disabling PreferLaterVersions feature; reason: " + x.getMessage());
            throw new BrokerFilterBadVersionException("Cannot determine newest broker version: " + x.getMessage());
        }
        int numBrokersLatestVersion = 0;
        int numBrokersOlderVersion = 0;
        Iterator<String> brokerIterator = brokers.iterator();
        while (brokerIterator.hasNext()) {
            String broker = brokerIterator.next();
            BrokerData data = loadData.getBrokerData().get(broker);
            String brokerVersion = data.getLocalData().getBrokerVersionString();
            Version brokerVersionVersion = Version.valueOf((String)brokerVersion);
            if (brokerVersionVersion.equals((Object)latestVersion)) {
                LOG.debug("Broker [{}] is running the latest version ([{}])", (Object)broker, (Object)brokerVersion);
                ++numBrokersLatestVersion;
                continue;
            }
            LOG.info("Broker [{}] is running an older version ([{}]); latest version is [{}]", new Object[]{broker, brokerVersion, latestVersion});
            ++numBrokersOlderVersion;
            brokerIterator.remove();
        }
        if (numBrokersOlderVersion == 0) {
            LOG.info("All {} brokers are running the latest version [{}]", (Object)numBrokersLatestVersion, (Object)latestVersion);
        }
    }
}

