/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.broker.qos.DefaultMonotonicClock;
import org.apache.pulsar.broker.qos.DynamicRateAsyncTokenBucketBuilder;
import org.apache.pulsar.broker.qos.FinalRateAsyncTokenBucketBuilder;
import org.apache.pulsar.broker.qos.MonotonicClock;

public abstract class AsyncTokenBucket {
    public static final MonotonicClock DEFAULT_SNAPSHOT_CLOCK = new DefaultMonotonicClock();
    static final long ONE_SECOND_NANOS = TimeUnit.SECONDS.toNanos(1L);
    public static final long DEFAULT_ADD_TOKENS_RESOLUTION_NANOS = TimeUnit.MILLISECONDS.toNanos(16L);
    private static final AtomicLongFieldUpdater<AsyncTokenBucket> LAST_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncTokenBucket.class, "lastNanos");
    private static final AtomicLongFieldUpdater<AsyncTokenBucket> TOKENS_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncTokenBucket.class, "tokens");
    private static final AtomicLongFieldUpdater<AsyncTokenBucket> REMAINDER_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncTokenBucket.class, "remainderNanos");
    protected volatile long tokens;
    private volatile long lastNanos;
    private volatile long remainderNanos;
    protected final long addTokensResolutionNanos;
    private final MonotonicClock clockSource;
    private final LongAdder pendingConsumedTokens = new LongAdder();

    protected AsyncTokenBucket(MonotonicClock clockSource, long addTokensResolutionNanos) {
        this.clockSource = clockSource;
        this.addTokensResolutionNanos = addTokensResolutionNanos;
        this.lastNanos = Long.MIN_VALUE;
    }

    public static FinalRateAsyncTokenBucketBuilder builder() {
        return new FinalRateAsyncTokenBucketBuilder();
    }

    public static DynamicRateAsyncTokenBucketBuilder builderForDynamicRate() {
        return new DynamicRateAsyncTokenBucketBuilder();
    }

    protected abstract long getRatePeriodNanos();

    protected abstract long getTargetAmountOfTokensAfterThrottling();

    private long consumeTokensAndMaybeUpdateTokensBalance(long consumeTokens) {
        if (consumeTokens < 0L) {
            throw new IllegalArgumentException("consumeTokens must be >= 0");
        }
        long currentNanos = this.clockSource.getTickNanos();
        long newTokens = this.calculateNewTokensSinceLastUpdate(currentNanos);
        if (newTokens > 0L) {
            long currentPendingConsumedTokens = this.pendingConsumedTokens.sumThenReset();
            long tokenDelta = newTokens - currentPendingConsumedTokens;
            if (tokenDelta != 0L || consumeTokens != 0L) {
                return TOKENS_UPDATER.updateAndGet(this, currentTokens -> Math.min(currentTokens + tokenDelta, this.getCapacity()) - consumeTokens);
            }
            return this.tokens;
        }
        if (consumeTokens > 0L) {
            this.pendingConsumedTokens.add(consumeTokens);
        }
        return this.tokens - this.pendingConsumedTokens.sum();
    }

    private long calculateNewTokensSinceLastUpdate(long currentNanos) {
        long newTokens;
        long previousLastNanos = this.lastNanos;
        long minimumIncrementNanos = this.getNanosForOneToken() > this.addTokensResolutionNanos ? this.getNanosForOneToken() - this.remainderNanos - 1L : this.addTokensResolutionNanos;
        long newLastNanos = currentNanos > previousLastNanos + minimumIncrementNanos ? currentNanos : previousLastNanos;
        if (newLastNanos == previousLastNanos || !LAST_NANOS_UPDATER.compareAndSet(this, previousLastNanos, newLastNanos) || previousLastNanos == Long.MIN_VALUE) {
            newTokens = 0L;
        } else {
            long currentRatePeriodNanos;
            long currentRate;
            long durationNanos = currentNanos - previousLastNanos + REMAINDER_NANOS_UPDATER.getAndSet(this, 0L);
            long remainderNanos = durationNanos - (newTokens = durationNanos * (currentRate = this.getRate()) / (currentRatePeriodNanos = this.getRatePeriodNanos())) * currentRatePeriodNanos / currentRate;
            if (remainderNanos > 0L) {
                REMAINDER_NANOS_UPDATER.addAndGet(this, remainderNanos);
            }
        }
        return newTokens;
    }

    public void consumeTokens(long consumeTokens) {
        if (consumeTokens < 0L) {
            throw new IllegalArgumentException("consumeTokens must be >= 0");
        }
        if (consumeTokens > 0L) {
            this.pendingConsumedTokens.add(consumeTokens);
        }
    }

    public boolean consumeTokensAndCheckIfContainsTokens(long consumeTokens) {
        return this.consumeTokensAndMaybeUpdateTokensBalance(consumeTokens) > 0L;
    }

    private long tokens() {
        return this.consumeTokensAndMaybeUpdateTokensBalance(0L);
    }

    public long calculateThrottlingDuration() {
        return this.calculateThrottlingDuration(Math.max(1L, this.getTargetAmountOfTokensAfterThrottling()));
    }

    public long calculateThrottlingDuration(long requiredTokens) {
        long currentTokens = this.consumeTokensAndMaybeUpdateTokensBalance(0L);
        if (currentTokens >= requiredTokens) {
            return 0L;
        }
        long needTokens = requiredTokens - currentTokens;
        return needTokens * this.getRatePeriodNanos() / this.getRate();
    }

    public abstract long getCapacity();

    public final long getTokens() {
        return this.tokens();
    }

    public abstract long getRate();

    protected abstract long getNanosForOneToken();

    public boolean containsTokens() {
        return this.tokens() > 0L;
    }
}

