/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SniHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.AsyncMapping;
import io.grpc.netty.shaded.io.netty.util.concurrent.ImmediateExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SocketAddress;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.SslContextProvider;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.VertxSniHandler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.VertxSslContext;

public class SslChannelProvider {
    private final long sslHandshakeTimeout;
    private final TimeUnit sslHandshakeTimeoutUnit;
    private final Executor workerPool;
    private final boolean useWorkerPool;
    private final boolean sni;
    private final boolean useAlpn;
    private final boolean trustAll;
    private final SslContextProvider sslContextProvider;
    private final SslContext[] sslContexts = new SslContext[2];
    private final Map<String, SslContext>[] sslContextMaps = new Map[]{new ConcurrentHashMap(), new ConcurrentHashMap()};

    public SslChannelProvider(SslContextProvider sslContextProvider, long sslHandshakeTimeout, TimeUnit sslHandshakeTimeoutUnit, boolean sni, boolean trustAll, boolean useAlpn, Executor workerPool, boolean useWorkerPool) {
        this.workerPool = workerPool;
        this.useWorkerPool = useWorkerPool;
        this.useAlpn = useAlpn;
        this.sni = sni;
        this.trustAll = trustAll;
        this.sslHandshakeTimeout = sslHandshakeTimeout;
        this.sslHandshakeTimeoutUnit = sslHandshakeTimeoutUnit;
        this.sslContextProvider = sslContextProvider;
    }

    public int sniEntrySize() {
        return this.sslContextMaps[0].size() + this.sslContextMaps[1].size();
    }

    public SslContextProvider sslContextProvider() {
        return this.sslContextProvider;
    }

    public SslContext sslClientContext(String serverName, boolean useAlpn) {
        return this.sslClientContext(serverName, useAlpn, this.trustAll);
    }

    public SslContext sslClientContext(String serverName, boolean useAlpn, boolean trustAll) {
        try {
            return this.sslContext(serverName, useAlpn, false, trustAll);
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public SslContext sslContext(String serverName, boolean useAlpn, boolean server, boolean trustAll) throws Exception {
        int idx = SslChannelProvider.idx(useAlpn);
        if (serverName != null) {
            TrustManager[] trustManagers;
            KeyManagerFactory kmf = this.sslContextProvider.resolveKeyManagerFactory(serverName);
            TrustManager[] trustManagerArray = trustManagers = trustAll ? null : this.sslContextProvider.resolveTrustManagers(serverName);
            if (kmf != null || trustManagers != null || !server) {
                return this.sslContextMaps[idx].computeIfAbsent(serverName, s -> this.sslContextProvider.createContext(server, kmf, trustManagers, (String)s, useAlpn, trustAll));
            }
        }
        if (this.sslContexts[idx] == null) {
            VertxSslContext context = this.sslContextProvider.createContext(server, null, null, serverName, useAlpn, trustAll);
            this.sslContexts[idx] = context;
        }
        return this.sslContexts[idx];
    }

    public SslContext sslServerContext(boolean useAlpn) {
        try {
            return this.sslContext(null, useAlpn, true, false);
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public AsyncMapping<? super String, ? extends SslContext> serverNameMapping() {
        return (serverName, promise) -> {
            this.workerPool.execute(() -> {
                SslContext sslContext;
                try {
                    sslContext = this.sslContext((String)serverName, this.useAlpn, true, false);
                }
                catch (Exception e) {
                    promise.setFailure((Throwable)e);
                    return;
                }
                promise.setSuccess((Object)sslContext);
            });
            return promise;
        };
    }

    public SslHandler createClientSslHandler(SocketAddress remoteAddress, String serverName, boolean useAlpn) {
        SslContext sslContext = this.sslClientContext(serverName, useAlpn);
        Object delegatedTaskExec = this.useWorkerPool ? this.workerPool : ImmediateExecutor.INSTANCE;
        SslHandler sslHandler = remoteAddress.isDomainSocket() ? sslContext.newHandler(ByteBufAllocator.DEFAULT, (Executor)delegatedTaskExec) : sslContext.newHandler(ByteBufAllocator.DEFAULT, remoteAddress.host(), remoteAddress.port(), (Executor)delegatedTaskExec);
        sslHandler.setHandshakeTimeout(this.sslHandshakeTimeout, this.sslHandshakeTimeoutUnit);
        return sslHandler;
    }

    public ChannelHandler createServerHandler() {
        if (this.sni) {
            return this.createSniHandler();
        }
        return this.createServerSslHandler(this.useAlpn);
    }

    private SslHandler createServerSslHandler(boolean useAlpn) {
        SslContext sslContext = this.sslServerContext(useAlpn);
        Object delegatedTaskExec = this.useWorkerPool ? this.workerPool : ImmediateExecutor.INSTANCE;
        SslHandler sslHandler = sslContext.newHandler(ByteBufAllocator.DEFAULT, (Executor)delegatedTaskExec);
        sslHandler.setHandshakeTimeout(this.sslHandshakeTimeout, this.sslHandshakeTimeoutUnit);
        return sslHandler;
    }

    private SniHandler createSniHandler() {
        Object delegatedTaskExec = this.useWorkerPool ? this.workerPool : ImmediateExecutor.INSTANCE;
        return new VertxSniHandler(this.serverNameMapping(), this.sslHandshakeTimeoutUnit.toMillis(this.sslHandshakeTimeout), (Executor)delegatedTaskExec);
    }

    private static int idx(boolean useAlpn) {
        return useAlpn ? 0 : 1;
    }
}

