/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.grpc.stub;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.ReadStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.WriteStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.grpc.stub.GrpcWriteStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.grpc.stub.StreamObserverReadStream;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <I, O> Future<O> oneToOne(ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate) {
        Promise promise = ctx != null ? ctx.promise() : Promise.promise();
        delegate.accept(request, ClientCalls.toStreamObserver(promise));
        return promise.future();
    }

    public static <I, O> ReadStream<O> oneToMany(ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate) {
        return ClientCalls.oneToMany(ctx, request, delegate, null, null, null);
    }

    public static <I, O> ReadStream<O> oneToMany(ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate, Handler<O> handler, Handler<Void> endHandler, Handler<Throwable> exceptionHandler) {
        StreamObserverReadStream<O> response = new StreamObserverReadStream<O>();
        response.handler(handler).endHandler(endHandler).exceptionHandler((Handler)exceptionHandler);
        delegate.accept(request, response);
        return response;
    }

    public static <I, O> Future<O> manyToOne(ContextInternal ctx, Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        Promise promise = ctx != null ? ctx.promise() : Promise.promise();
        StreamObserver<I> request = delegate.apply(ClientCalls.toStreamObserver(promise));
        requestHandler.handle(new GrpcWriteStream<I>(request));
        return promise.future();
    }

    public static <I, O> ReadStream<O> manyToMany(ContextInternal ctx, Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        return ClientCalls.manyToMany(ctx, requestHandler, delegate, null);
    }

    public static <I, O> ReadStream<O> manyToMany(ContextInternal ctx, Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate, Handler<Throwable> exceptionHandler) {
        return ClientCalls.manyToMany(ctx, requestHandler, delegate, null, null, null);
    }

    public static <I, O> ReadStream<O> manyToMany(ContextInternal ctx, Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate, Handler<O> handler, Handler<Void> endHandler, Handler<Throwable> exceptionHandler) {
        StreamObserverReadStream<O> response = new StreamObserverReadStream<O>();
        response.handler(handler).endHandler(endHandler).exceptionHandler((Handler)exceptionHandler);
        StreamObserver<I> request = delegate.apply(response);
        requestHandler.handle(new GrpcWriteStream<I>(request));
        return response;
    }

    private static <O> StreamObserver<O> toStreamObserver(final Promise<O> promise) {
        return new StreamObserver<O>(){

            public void onNext(O tResponse) {
                if (!promise.tryComplete(tResponse)) {
                    throw Status.INTERNAL.withDescription("More than one responses received for unary or client-streaming call").asRuntimeException();
                }
            }

            public void onError(Throwable throwable) {
                promise.tryFail(throwable);
            }

            public void onCompleted() {
            }
        };
    }
}

