/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.util.concurrent.RateLimiter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.MultiTopicsConsumerImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PerformanceTopicListArguments;
import org.apache.pulsar.testclient.PositiveNumberParameterConvert;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="consume", description={"Test pulsar consumer performance."})
public class PerformanceConsumer
extends PerformanceTopicListArguments {
    private static final LongAdder messagesReceived = new LongAdder();
    private static final LongAdder bytesReceived = new LongAdder();
    private static final DecimalFormat intFormat = new PaddingDecimalFormat("0", 7);
    private static final DecimalFormat dec = new DecimalFormat("0.000");
    private static final LongAdder totalMessagesReceived = new LongAdder();
    private static final LongAdder totalBytesReceived = new LongAdder();
    private static final LongAdder totalNumTxnOpenFail = new LongAdder();
    private static final LongAdder totalNumTxnOpenSuccess = new LongAdder();
    private static final LongAdder totalMessageAck = new LongAdder();
    private static final LongAdder totalMessageAckFailed = new LongAdder();
    private static final LongAdder messageAck = new LongAdder();
    private static final LongAdder totalEndTxnOpFailNum = new LongAdder();
    private static final LongAdder totalEndTxnOpSuccessNum = new LongAdder();
    private static final LongAdder numTxnOpSuccess = new LongAdder();
    private static final long MAX_LATENCY = TimeUnit.DAYS.toMillis(10L);
    private static final Recorder recorder = new Recorder(MAX_LATENCY, 5);
    private static final Recorder cumulativeRecorder = new Recorder(MAX_LATENCY, 5);
    @CommandLine.Option(names={"-n", "--num-consumers"}, description={"Number of consumers (per subscription), only one consumer is allowed when subscriptionType is Exclusive"}, converter={PositiveNumberParameterConvert.class})
    public int numConsumers = 1;
    @CommandLine.Option(names={"-ns", "--num-subscriptions"}, description={"Number of subscriptions (per topic)"}, converter={PositiveNumberParameterConvert.class})
    public int numSubscriptions = 1;
    @CommandLine.Option(names={"-s", "--subscriber-name"}, description={"Subscriber name prefix"}, hidden=true)
    public String subscriberName;
    @CommandLine.Option(names={"-ss", "--subscriptions"}, description={"A list of subscriptions to consume (for example, sub1,sub2)"})
    public List<String> subscriptions = Collections.singletonList("sub");
    @CommandLine.Option(names={"-st", "--subscription-type"}, description={"Subscription type"})
    public SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    @CommandLine.Option(names={"-sp", "--subscription-position"}, description={"Subscription position"})
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
    @CommandLine.Option(names={"-r", "--rate"}, description={"Simulate a slow message consumer (rate in msg/s)"})
    public double rate = 0.0;
    @CommandLine.Option(names={"-q", "--receiver-queue-size"}, description={"Size of the receiver queue"})
    public int receiverQueueSize = 1000;
    @CommandLine.Option(names={"-p", "--receiver-queue-size-across-partitions"}, description={"Max total size of the receiver queue across partitions"})
    public int maxTotalReceiverQueueSizeAcrossPartitions = 50000;
    @CommandLine.Option(names={"-aq", "--auto-scaled-receiver-queue-size"}, description={"Enable autoScaledReceiverQueueSize"})
    public boolean autoScaledReceiverQueueSize = false;
    @CommandLine.Option(names={"-rs", "--replicated"}, description={"Whether the subscription status should be replicated"})
    public boolean replicatedSubscription = false;
    @CommandLine.Option(names={"--acks-delay-millis"}, description={"Acknowledgements grouping delay in millis"})
    public int acknowledgmentsGroupingDelayMillis = 100;
    @CommandLine.Option(names={"-m", "--num-messages"}, description={"Number of messages to consume in total. If <= 0, it will keep consuming"})
    public long numMessages = 0L;
    @CommandLine.Option(names={"-mc", "--max_chunked_msg"}, description={"Max pending chunk messages"})
    private int maxPendingChunkedMessage = 0;
    @CommandLine.Option(names={"-ac", "--auto_ack_chunk_q_full"}, description={"Auto ack for oldest message on queue is full"})
    private boolean autoAckOldestChunkedMessageOnQueueFull = false;
    @CommandLine.Option(names={"-e", "--expire_time_incomplete_chunked_messages"}, description={"Expire time in ms for incomplete chunk messages"})
    private long expireTimeOfIncompleteChunkedMessageMs = 0L;
    @CommandLine.Option(names={"-v", "--encryption-key-value-file"}, description={"The file which contains the private key to decrypt payload"})
    public String encKeyFile = null;
    @CommandLine.Option(names={"-time", "--test-duration"}, description={"Test duration in secs. If <= 0, it will keep consuming"})
    public long testTime = 0L;
    @CommandLine.Option(names={"--batch-index-ack"}, description={"Enable or disable the batch index acknowledgment"})
    public boolean batchIndexAck = false;
    @CommandLine.Option(names={"-pm", "--pool-messages"}, description={"Use the pooled message"}, arity="1")
    private boolean poolMessages = true;
    @CommandLine.Option(names={"-tto", "--txn-timeout"}, description={"Set the time value of transaction timeout, and the time unit is second. (After --txn-enable setting to true, --txn-timeout takes effect)"})
    public long transactionTimeout = 10L;
    @CommandLine.Option(names={"-nmt", "--numMessage-perTransaction"}, description={"The number of messages acknowledged by a transaction. (After --txn-enable setting to true, -numMessage-perTransaction takes effect"})
    public int numMessagesPerTransaction = 50;
    @CommandLine.Option(names={"-txn", "--txn-enable"}, description={"Enable or disable the transaction"})
    public boolean isEnableTransaction = false;
    @CommandLine.Option(names={"-ntxn"}, description={"The number of opened transactions, 0 means keeping open.(After --txn-enable setting to true, -ntxn takes effect.)"})
    public long totalNumTxn = 0L;
    @CommandLine.Option(names={"-abort"}, description={"Abort the transaction. (After --txn-enable setting to true, -abort takes effect)"})
    public boolean isAbortTransaction = false;
    @CommandLine.Option(names={"--histogram-file"}, description={"HdrHistogram output file"})
    public String histogramFile = null;
    private static final Logger log = LoggerFactory.getLogger(PerformanceConsumer.class);

    public PerformanceConsumer() {
        super("consume");
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        if (this.subscriptionType == SubscriptionType.Exclusive && this.numConsumers > 1) {
            throw new Exception("Only one consumer is allowed when subscriptionType is Exclusive");
        }
        if (this.subscriptions != null && this.subscriptions.size() != this.numSubscriptions) {
            if (this.subscriptions.size() == 1) {
                if (this.subscriberName == null) {
                    this.subscriberName = this.subscriptions.get(0);
                }
                ArrayList<String> defaultSubscriptions = new ArrayList<String>();
                for (int i = 0; i < this.numSubscriptions; ++i) {
                    defaultSubscriptions.add(String.format("%s-%d", this.subscriberName, i));
                }
                this.subscriptions = defaultSubscriptions;
            } else {
                throw new Exception("The size of subscriptions list should be equal to --num-subscriptions");
            }
        }
    }

    @Override
    public void run() throws Exception {
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar performance consumer with config: {}", (Object)w.writeValueAsString((Object)this));
        Recorder qRecorder = this.autoScaledReceiverQueueSize ? new Recorder((long)this.receiverQueueSize, 5) : null;
        RateLimiter limiter = this.rate > 0.0 ? RateLimiter.create((double)this.rate) : null;
        long startTime = System.nanoTime();
        long testEndTime = startTime + (long)((double)this.testTime * 1.0E9);
        ClientBuilder clientBuilder = PerfClientUtils.createClientBuilderFromArguments(this).enableTransaction(this.isEnableTransaction);
        PulsarClient pulsarClient = clientBuilder.build();
        AtomicReference<Object> atomicReference = this.isEnableTransaction ? new AtomicReference<Transaction>((Transaction)pulsarClient.newTransaction().withTransactionTimeout(this.transactionTimeout, TimeUnit.SECONDS).build().get()) : new AtomicReference<Object>(null);
        AtomicLong messageAckedCount = new AtomicLong();
        Semaphore messageReceiveLimiter = new Semaphore(this.numMessagesPerTransaction);
        Thread thread = Thread.currentThread();
        MessageListener & Serializable listener = (MessageListener & Serializable)(consumer, msg) -> {
            long latencyMillis;
            if (this.testTime > 0L && System.nanoTime() > testEndTime) {
                log.info("------------------- DONE -----------------------");
                PerfClientUtils.exit(0);
                thread.interrupt();
            }
            if (this.totalNumTxn > 0L && totalEndTxnOpFailNum.sum() + totalEndTxnOpSuccessNum.sum() >= this.totalNumTxn) {
                log.info("------------------- DONE -----------------------");
                PerfClientUtils.exit(0);
                thread.interrupt();
            }
            if (qRecorder != null) {
                qRecorder.recordValue((long)((ConsumerBase)consumer).getTotalIncomingMessages());
            }
            messagesReceived.increment();
            bytesReceived.add(msg.size());
            totalMessagesReceived.increment();
            totalBytesReceived.add(msg.size());
            if (this.numMessages > 0L && totalMessagesReceived.sum() >= this.numMessages) {
                log.info("------------------- DONE -----------------------");
                PerfClientUtils.exit(0);
                thread.interrupt();
            }
            if (limiter != null) {
                limiter.acquire();
            }
            if ((latencyMillis = System.currentTimeMillis() - msg.getPublishTime()) >= 0L) {
                if (latencyMillis >= MAX_LATENCY) {
                    latencyMillis = MAX_LATENCY;
                }
                recorder.recordValue(latencyMillis);
                cumulativeRecorder.recordValue(latencyMillis);
            }
            if (this.isEnableTransaction) {
                try {
                    messageReceiveLimiter.acquire();
                }
                catch (InterruptedException e) {
                    log.error("Got error: ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                ((CompletableFuture)consumer.acknowledgeAsync(msg.getMessageId(), (Transaction)atomicReference.get()).thenRun(() -> {
                    totalMessageAck.increment();
                    messageAck.increment();
                })).exceptionally(throwable -> {
                    log.error("Ack message {} failed with exception", (Object)msg, throwable);
                    totalMessageAckFailed.increment();
                    if (PerfClientUtils.hasInterruptedException(throwable)) {
                        Thread.currentThread().interrupt();
                    }
                    return null;
                });
            } else {
                ((CompletableFuture)consumer.acknowledgeAsync(msg).thenRun(() -> {
                    totalMessageAck.increment();
                    messageAck.increment();
                })).exceptionally(throwable -> {
                    if (PerfClientUtils.hasInterruptedException(throwable)) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                    log.error("Ack message {} failed with exception", (Object)msg, throwable);
                    totalMessageAckFailed.increment();
                    return null;
                });
            }
            if (this.poolMessages) {
                msg.release();
            }
            if (this.isEnableTransaction && messageAckedCount.incrementAndGet() == (long)this.numMessagesPerTransaction) {
                Transaction transaction = (Transaction)atomicReference.get();
                if (!this.isAbortTransaction) {
                    ((CompletableFuture)transaction.commit().thenRun(() -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Commit transaction {}", (Object)transaction.getTxnID());
                        }
                        totalEndTxnOpSuccessNum.increment();
                        numTxnOpSuccess.increment();
                    })).exceptionally(exception -> {
                        if (PerfClientUtils.hasInterruptedException(exception)) {
                            Thread.currentThread().interrupt();
                            return null;
                        }
                        log.error("Commit transaction failed with exception : ", exception);
                        totalEndTxnOpFailNum.increment();
                        return null;
                    });
                } else {
                    ((CompletableFuture)transaction.abort().thenRun(() -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Abort transaction {}", (Object)transaction.getTxnID());
                        }
                        totalEndTxnOpSuccessNum.increment();
                        numTxnOpSuccess.increment();
                    })).exceptionally(exception -> {
                        if (PerfClientUtils.hasInterruptedException(exception)) {
                            Thread.currentThread().interrupt();
                            return null;
                        }
                        log.error("Abort transaction {} failed with exception", (Object)transaction.getTxnID().toString(), exception);
                        totalEndTxnOpFailNum.increment();
                        return null;
                    });
                }
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Transaction newTransaction = (Transaction)pulsarClient.newTransaction().withTransactionTimeout(this.transactionTimeout, TimeUnit.SECONDS).build().get();
                        atomicReference.compareAndSet(transaction, newTransaction);
                        totalNumTxnOpenSuccess.increment();
                        messageAckedCount.set(0L);
                        messageReceiveLimiter.release(this.numMessagesPerTransaction);
                        break;
                    }
                    catch (Exception e) {
                        if (PerfClientUtils.hasInterruptedException(e)) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        log.error("Failed to new transaction with exception:", (Throwable)e);
                        totalNumTxnOpenFail.increment();
                    }
                }
            }
        };
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        ConsumerBuilder consumerBuilder = pulsarClient.newConsumer(Schema.BYTEBUFFER).messageListener((MessageListener)listener).receiverQueueSize(this.receiverQueueSize).maxTotalReceiverQueueSizeAcrossPartitions(this.maxTotalReceiverQueueSizeAcrossPartitions).acknowledgmentGroupTime((long)this.acknowledgmentsGroupingDelayMillis, TimeUnit.MILLISECONDS).subscriptionType(this.subscriptionType).subscriptionInitialPosition(this.subscriptionInitialPosition).autoAckOldestChunkedMessageOnQueueFull(this.autoAckOldestChunkedMessageOnQueueFull).enableBatchIndexAcknowledgment(this.batchIndexAck).poolMessages(this.poolMessages).replicateSubscriptionState(this.replicatedSubscription).autoScaledReceiverQueueSizeEnabled(this.autoScaledReceiverQueueSize);
        if (this.maxPendingChunkedMessage > 0) {
            consumerBuilder.maxPendingChunkedMessage(this.maxPendingChunkedMessage);
        }
        if (this.expireTimeOfIncompleteChunkedMessageMs > 0L) {
            consumerBuilder.expireTimeOfIncompleteChunkedMessage(this.expireTimeOfIncompleteChunkedMessageMs, TimeUnit.MILLISECONDS);
        }
        if (StringUtils.isNotBlank((CharSequence)this.encKeyFile)) {
            consumerBuilder.defaultCryptoKeyReader(this.encKeyFile);
        }
        for (int i = 0; i < this.numTopics; ++i) {
            TopicName topicName = TopicName.get((String)((String)this.topics.get(i)));
            log.info("Adding {} consumers per subscription on topic {}", (Object)this.numConsumers, (Object)topicName);
            for (int j = 0; j < this.numSubscriptions; ++j) {
                String subscriberName = this.subscriptions.get(j);
                for (int k = 0; k < this.numConsumers; ++k) {
                    futures.add(consumerBuilder.clone().topic(new String[]{topicName.toString()}).subscriptionName(subscriberName).subscribeAsync());
                }
            }
        }
        for (Future future : futures) {
            future.get();
        }
        log.info("Start receiving from {} consumers per subscription on {} topics", (Object)this.numConsumers, (Object)this.numTopics);
        long start = System.nanoTime();
        Thread shutdownHookThread = PerfClientUtils.addShutdownHook(() -> {
            this.printAggregatedThroughput(start);
            PerformanceConsumer.printAggregatedStats();
        });
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        Histogram qHistogram = null;
        HistogramLogWriter histogramLogWriter = null;
        if (this.histogramFile != null) {
            String statsFileName = this.histogramFile;
            log.info("Dumping latency stats to {}", (Object)statsFileName);
            PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
            histogramLogWriter = new HistogramLogWriter(histogramLog);
            histogramLogWriter.outputLogFormatVersion();
            histogramLogWriter.outputLegend();
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalMessagesReceived.sum();
            double rate = (double)messagesReceived.sumThenReset() / elapsed;
            double throughput = (double)bytesReceived.sumThenReset() / elapsed * 8.0 / 1024.0 / 1024.0;
            double rateAck = (double)messageAck.sumThenReset() / elapsed;
            long totalTxnOpSuccessNum = 0L;
            long totalTxnOpFailNum = 0L;
            double rateOpenTxn = 0.0;
            reportHistogram = recorder.getIntervalHistogram(reportHistogram);
            if (this.isEnableTransaction) {
                totalTxnOpSuccessNum = totalEndTxnOpSuccessNum.sum();
                totalTxnOpFailNum = totalEndTxnOpFailNum.sum();
                rateOpenTxn = (double)numTxnOpSuccess.sumThenReset() / elapsed;
                log.info("--- Transaction: {} transaction end successfully --- {} transaction end failed --- {}  Txn/s --- AckRate: {} msg/s", new Object[]{totalTxnOpSuccessNum, totalTxnOpFailNum, dec.format(rateOpenTxn), dec.format(rateAck)});
            }
            log.info("Throughput received: {} msg --- {}  msg/s --- {} Mbit/s  --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{intFormat.format(total), dec.format(rate), dec.format(throughput), dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getMaxValue()});
            if (this.autoScaledReceiverQueueSize && log.isDebugEnabled() && qRecorder != null) {
                qHistogram = qRecorder.getIntervalHistogram(qHistogram);
                log.debug("ReceiverQueueUsage: cnt={},mean={}, min={},max={},25pct={},50pct={},75pct={}", new Object[]{qHistogram.getTotalCount(), dec.format(qHistogram.getMean()), qHistogram.getMinValue(), qHistogram.getMaxValue(), qHistogram.getValueAtPercentile(25.0), qHistogram.getValueAtPercentile(50.0), qHistogram.getValueAtPercentile(75.0)});
                qHistogram.reset();
                for (Future future : futures) {
                    ConsumerBase consumerBase = (ConsumerBase)future.get();
                    log.debug("[{}] CurrentReceiverQueueSize={}", (Object)consumerBase.getConsumerName(), (Object)consumerBase.getCurrentReceiverQueueSize());
                    if (!(consumerBase instanceof MultiTopicsConsumerImpl)) continue;
                    for (ConsumerImpl consumer2 : ((MultiTopicsConsumerImpl)consumerBase).getConsumers()) {
                        log.debug("[{}] SubConsumer.CurrentReceiverQueueSize={}", (Object)consumer2.getConsumerName(), (Object)consumer2.getCurrentReceiverQueueSize());
                    }
                }
            }
            if (histogramLogWriter != null) {
                histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportHistogram);
            }
            reportHistogram.reset();
            oldTime = now;
            if (this.testTime <= 0L || now <= testEndTime) continue;
            log.info("------------------- DONE -----------------------");
            PerfClientUtils.exit(0);
            thread.interrupt();
        }
        PerfClientUtils.closeClient(pulsarClient);
        PerfClientUtils.removeAndRunShutdownHook(shutdownHookThread);
    }

    private void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesReceived.sum() / elapsed;
        double throughput = (double)totalBytesReceived.sum() / elapsed * 8.0 / 1024.0 / 1024.0;
        long totalEndTxnSuccess = 0L;
        long totalEndTxnFail = 0L;
        long numTransactionOpenFailed = 0L;
        long numTransactionOpenSuccess = 0L;
        long totalnumMessageAckFailed = 0L;
        double rateAck = (double)totalMessageAck.sum() / elapsed;
        double rateOpenTxn = 0.0;
        if (this.isEnableTransaction) {
            totalEndTxnSuccess = totalEndTxnOpSuccessNum.sum();
            totalEndTxnFail = totalEndTxnOpFailNum.sum();
            rateOpenTxn = (double)(totalEndTxnSuccess + totalEndTxnFail) / elapsed;
            totalnumMessageAckFailed = totalMessageAckFailed.sum();
            numTransactionOpenFailed = totalNumTxnOpenFail.sum();
            numTransactionOpenSuccess = totalNumTxnOpenSuccess.sum();
            log.info("-- Transaction: {}  transaction end successfully --- {} transaction end failed --- {} transaction open successfully --- {} transaction open failed --- {} Txn/s ", new Object[]{totalEndTxnSuccess, totalEndTxnFail, numTransactionOpenSuccess, numTransactionOpenFailed, dec.format(rateOpenTxn)});
        }
        log.info("Aggregated throughput stats --- {} records received --- {} msg/s --- {} Mbit/s --- AckRate: {}  msg/s --- ack failed {} msg", new Object[]{totalMessagesReceived.sum(), dec.format(rate), dec.format(throughput), rateAck, totalnumMessageAckFailed});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = cumulativeRecorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getValueAtPercentile(99.999), reportHistogram.getMaxValue()});
    }
}

