/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import com.google.common.io.BaseEncoding;
import io.grpc.Metadata;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class MetadataSetter
implements TextMapSetter<Metadata> {
    private static final Logger logger = Logger.getLogger(MetadataSetter.class.getName());
    private static final MetadataSetter INSTANCE = new MetadataSetter();

    MetadataSetter() {
    }

    public static MetadataSetter getInstance() {
        return INSTANCE;
    }

    public void set(@Nullable Metadata carrier, String key, String value) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, setting no data");
            return;
        }
        try {
            if (key.equals("grpc-trace-bin")) {
                carrier.put(Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER), (Object)BaseEncoding.base64().decode((CharSequence)value));
            } else {
                carrier.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, String.format("Failed to set metadata, key=%s", key), e);
        }
    }

    void set(@Nullable Metadata carrier, String key, byte[] value) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, setting no data");
            return;
        }
        if (!key.equals("grpc-trace-bin")) {
            logger.log(Level.INFO, "Only support 'grpc-trace-bin' binary header. Set no data");
            return;
        }
        try {
            carrier.put(Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER), (Object)value);
        }
        catch (Exception e) {
            logger.log(Level.INFO, String.format("Failed to set metadata key=%s", key), e);
        }
    }
}

