/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.commons.IOUtils;
import org.zeroturnaround.zip.transform.ZipEntryTransformer;

public class ZipEntrySourceZipEntryTransformer
implements ZipEntryTransformer {
    private final ZipEntrySource source;

    public ZipEntrySourceZipEntryTransformer(ZipEntrySource source) {
        this.source = source;
    }

    @Override
    public void transform(InputStream in, ZipEntry zipEntry, ZipOutputStream out) throws IOException {
        ZipEntrySourceZipEntryTransformer.addEntry(this.source, out);
    }

    static void addEntry(ZipEntrySource entry, ZipOutputStream out) throws IOException {
        out.putNextEntry(entry.getEntry());
        InputStream in = entry.getInputStream();
        if (in != null) {
            try {
                IOUtils.copy(in, out);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        out.closeEntry();
    }
}

