/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyStreamReader
extends InputStream {
    static final Logger LOG = LoggerFactory.getLogger(AppendOnlyStreamReader.class);
    private LogRecordWithInputStream currentLogRecord = null;
    private final DistributedLogManager dlm;
    private LogReader reader;
    private long currentPosition;
    private static final int SKIP_BUFFER_SIZE = 512;

    AppendOnlyStreamReader(DistributedLogManager dlm) throws IOException {
        this.dlm = dlm;
        this.reader = dlm.getInputStream(0L);
        this.currentPosition = 0L;
    }

    private LogRecordWithInputStream nextLogRecord() throws IOException {
        return AppendOnlyStreamReader.nextLogRecord(this.reader);
    }

    private static LogRecordWithInputStream nextLogRecord(LogReader reader) throws IOException {
        LogRecordWithDLSN record = reader.readNext(false);
        if (null != record) {
            return new LogRecordWithInputStream(record);
        }
        record = reader.readNext(false);
        if (null != record) {
            return new LogRecordWithInputStream(record);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No record");
        }
        return null;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != 1) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        if (this.currentLogRecord == null) {
            this.currentLogRecord = this.nextLogRecord();
            if (this.currentLogRecord == null) {
                return read;
            }
        }
        while (read < len) {
            int thisread = this.currentLogRecord.getPayLoadInputStream().read(b, off + read, len - read);
            if (thisread == -1) {
                this.currentLogRecord = this.nextLogRecord();
                if (this.currentLogRecord != null) continue;
                return read;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Offset saved = {}, persisted = {}", (Object)this.currentPosition, (Object)this.currentLogRecord.getLogRecord().getTransactionId());
            }
            this.currentPosition += (long)thisread;
            read += thisread;
        }
        return read;
    }

    public boolean skipTo(long position) throws IOException {
        if (position == this.position()) {
            return true;
        }
        LogReader skipReader = this.dlm.getInputStream(position);
        LogRecordWithInputStream logRecord = null;
        try {
            logRecord = AppendOnlyStreamReader.nextLogRecord(skipReader);
        }
        catch (IOException ex) {
            skipReader.close();
            throw ex;
        }
        if (null == logRecord) {
            return false;
        }
        this.currentPosition = logRecord.getOffset();
        this.currentLogRecord = logRecord;
        LogReader oldReader = this.reader;
        this.reader = skipReader;
        oldReader.close();
        byte[] skipBuffer = new byte[512];
        while (this.currentPosition < position) {
            long bytesToRead = Math.min(position - this.currentPosition, 512L);
            long bytesRead = this.read(skipBuffer, 0, (int)bytesToRead);
            if (bytesRead >= bytesToRead) continue;
            return false;
        }
        return true;
    }

    public long position() {
        return this.currentPosition;
    }

    private static class LogRecordWithInputStream {
        private final InputStream payloadStream;
        private final LogRecordWithDLSN logRecord;

        LogRecordWithInputStream(LogRecordWithDLSN logRecord) {
            Preconditions.checkNotNull((Object)logRecord);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got record dlsn = {}, txid = {}, len = {}", new Object[]{logRecord.getDlsn(), logRecord.getTransactionId(), logRecord.getPayload().length});
            }
            this.logRecord = logRecord;
            this.payloadStream = logRecord.getPayLoadInputStream();
        }

        InputStream getPayLoadInputStream() {
            return this.payloadStream;
        }

        LogRecordWithDLSN getLogRecord() {
            return this.logRecord;
        }

        long getOffset() {
            return this.logRecord.getTransactionId() - (long)this.logRecord.getPayload().length;
        }
    }
}

