/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stats.AlertStatsLogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.AsyncNotification;
import org.apache.distributedlog.BKLogHandler;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.callback.LogSegmentListener;
import org.apache.distributedlog.callback.LogSegmentNamesListener;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.exceptions.LogSegmentNotFoundException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.lock.DistributedLock;
import org.apache.distributedlog.logsegment.LogSegmentEntryStore;
import org.apache.distributedlog.logsegment.LogSegmentFilter;
import org.apache.distributedlog.logsegment.LogSegmentMetadataCache;
import org.apache.distributedlog.metadata.LogMetadataForReader;
import org.apache.distributedlog.metadata.LogStreamMetadataStore;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BKLogReadHandler
extends BKLogHandler
implements LogSegmentNamesListener {
    static final Logger LOG = LoggerFactory.getLogger(BKLogReadHandler.class);
    protected final LogMetadataForReader logMetadataForReader;
    protected final DynamicDistributedLogConfiguration dynConf;
    private final Optional<String> subscriberId;
    private DistributedLock readLock;
    private CompletableFuture<Void> lockAcquireFuture;
    protected final AsyncNotification readerStateNotification;
    protected boolean logSegmentsNotificationDisabled = false;
    protected final CopyOnWriteArraySet<LogSegmentListener> listeners = new CopyOnWriteArraySet();
    protected Versioned<List<LogSegmentMetadata>> lastNotifiedLogSegments = new Versioned(null, Version.NEW);
    private final StatsLogger perLogStatsLogger;

    BKLogReadHandler(LogMetadataForReader logMetadata, Optional<String> subscriberId, DistributedLogConfiguration conf, DynamicDistributedLogConfiguration dynConf, LogStreamMetadataStore streamMetadataStore, LogSegmentMetadataCache metadataCache, LogSegmentEntryStore entryStore, OrderedScheduler scheduler, AlertStatsLogger alertStatsLogger, StatsLogger statsLogger, StatsLogger perLogStatsLogger, String clientId, AsyncNotification readerStateNotification, boolean isHandleForReading) {
        super(logMetadata, conf, streamMetadataStore, metadataCache, entryStore, scheduler, statsLogger, alertStatsLogger, clientId);
        this.logMetadataForReader = logMetadata;
        this.dynConf = dynConf;
        this.perLogStatsLogger = isHandleForReading ? perLogStatsLogger : NullStatsLogger.INSTANCE;
        this.readerStateNotification = readerStateNotification;
        this.subscriberId = subscriberId;
    }

    @VisibleForTesting
    String getReadLockPath() {
        return this.logMetadataForReader.getReadLockPath(this.subscriberId);
    }

    CompletableFuture<Void> checkLogStreamExists() {
        return this.streamMetadataStore.logExists(this.logMetadata.getUri(), this.logMetadata.getLogName());
    }

    synchronized CompletableFuture<Void> lockStream() {
        if (null == this.lockAcquireFuture) {
            this.lockAcquireFuture = this.streamMetadataStore.createReadLock(this.logMetadataForReader, this.subscriberId).thenCompose(lock -> {
                try {
                    this.readLock = lock;
                    LOG.info("acquiring readlock {} at {}", (Object)this.getLockClientId(), (Object)this.getReadLockPath());
                    return this.acquireLockOnExecutorThread((DistributedLock)lock);
                }
                catch (LockingException le) {
                    return FutureUtils.exception((Throwable)le);
                }
            });
        }
        return this.lockAcquireFuture;
    }

    CompletableFuture<Void> acquireLockOnExecutorThread(DistributedLock lock) throws LockingException {
        CompletableFuture<? extends DistributedLock> acquireFuture = lock.asyncAcquire();
        final CompletableFuture<Void> threadAcquirePromise = new CompletableFuture<Void>();
        threadAcquirePromise.whenComplete((value, cause) -> {
            if (cause instanceof CancellationException) {
                acquireFuture.cancel(true);
            }
        });
        acquireFuture.whenCompleteAsync((BiConsumer)new FutureEventListener<DistributedLock>(){

            public void onSuccess(DistributedLock lock) {
                LOG.info("acquired readlock {} at {}", (Object)BKLogReadHandler.this.getLockClientId(), (Object)BKLogReadHandler.this.getReadLockPath());
                threadAcquirePromise.complete(null);
            }

            public void onFailure(Throwable cause) {
                LOG.info("failed to acquire readlock {} at {}", new Object[]{BKLogReadHandler.this.getLockClientId(), BKLogReadHandler.this.getReadLockPath(), cause});
                threadAcquirePromise.completeExceptionally(cause);
            }
        });
        return threadAcquirePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkReadLock() throws DLIllegalStateException, LockingException {
        BKLogReadHandler bKLogReadHandler = this;
        synchronized (bKLogReadHandler) {
            if (null == this.lockAcquireFuture || !this.lockAcquireFuture.isDone()) {
                throw new DLIllegalStateException("Attempt to check for lock before it has been acquired successfully");
            }
        }
        this.readLock.checkOwnership();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> asyncClose() {
        DistributedLock lockToClose;
        BKLogReadHandler bKLogReadHandler = this;
        synchronized (bKLogReadHandler) {
            if (null != this.lockAcquireFuture && !this.lockAcquireFuture.isDone()) {
                this.lockAcquireFuture.cancel(true);
            }
            lockToClose = this.readLock;
        }
        return Utils.closeSequence((ExecutorService)this.scheduler, lockToClose).thenApply(value -> {
            this.metadataStore.unregisterLogSegmentListener(this.logMetadata.getLogSegmentsPath(), this);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> asyncAbort() {
        return this.asyncClose();
    }

    CompletableFuture<Versioned<List<LogSegmentMetadata>>> asyncStartFetchLogSegments() {
        CompletableFuture<Versioned<List<LogSegmentMetadata>>> promise = new CompletableFuture<Versioned<List<LogSegmentMetadata>>>();
        this.asyncStartFetchLogSegments(promise);
        return promise;
    }

    void asyncStartFetchLogSegments(final CompletableFuture<Versioned<List<LogSegmentMetadata>>> promise) {
        this.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, this).whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

            public void onFailure(Throwable cause) {
                if (cause instanceof LogNotFoundException || cause instanceof LogSegmentNotFoundException || cause instanceof UnexpectedException) {
                    BKLogHandler.METADATA_EXCEPTION_UPDATER.compareAndSet(BKLogReadHandler.this, null, (IOException)cause);
                    BKLogReadHandler.this.notifyReaderOnError(cause);
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)cause);
                    return;
                }
                BKLogReadHandler.this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        BKLogReadHandler.this.asyncStartFetchLogSegments(promise);
                    }
                }, (long)BKLogReadHandler.this.conf.getZKRetryBackoffMaxMillis(), TimeUnit.MILLISECONDS);
            }

            public void onSuccess(Versioned<List<LogSegmentMetadata>> segments) {
                FutureUtils.complete((CompletableFuture)promise, segments);
            }
        });
    }

    @VisibleForTesting
    void disableReadAheadLogSegmentsNotification() {
        this.logSegmentsNotificationDisabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSegmentsUpdated(final Versioned<List<String>> segments) {
        BKLogReadHandler bKLogReadHandler = this;
        synchronized (bKLogReadHandler) {
            if (this.lastNotifiedLogSegments.getVersion() != Version.NEW && this.lastNotifiedLogSegments.getVersion().compare(segments.getVersion()) != Version.Occurred.BEFORE) {
                return;
            }
        }
        CompletableFuture<Versioned<List<LogSegmentMetadata>>> readLogSegmentsPromise = new CompletableFuture<Versioned<List<LogSegmentMetadata>>>();
        readLogSegmentsPromise.whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

            public void onFailure(Throwable cause) {
                if (cause instanceof LogNotFoundException || cause instanceof LogSegmentNotFoundException || cause instanceof UnexpectedException) {
                    BKLogHandler.METADATA_EXCEPTION_UPDATER.compareAndSet(BKLogReadHandler.this, null, (IOException)cause);
                    BKLogReadHandler.this.notifyReaderOnError(cause);
                    return;
                }
                BKLogReadHandler.this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        BKLogReadHandler.this.onSegmentsUpdated((Versioned<List<String>>)segments);
                    }
                }, (long)BKLogReadHandler.this.conf.getZKRetryBackoffMaxMillis(), TimeUnit.MILLISECONDS);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(Versioned<List<LogSegmentMetadata>> logSegments) {
                List segmentsToNotify = null;
                BKLogReadHandler bKLogReadHandler = BKLogReadHandler.this;
                synchronized (bKLogReadHandler) {
                    Versioned<List<LogSegmentMetadata>> lastLogSegments = BKLogReadHandler.this.lastNotifiedLogSegments;
                    if (lastLogSegments.getVersion() == Version.NEW || lastLogSegments.getVersion().compare(logSegments.getVersion()) == Version.Occurred.BEFORE) {
                        BKLogReadHandler.this.lastNotifiedLogSegments = logSegments;
                        segmentsToNotify = (List)logSegments.getValue();
                    }
                }
                if (null != segmentsToNotify) {
                    BKLogReadHandler.this.notifyUpdatedLogSegments(segmentsToNotify);
                }
            }
        });
        this.readLogSegmentsFromStore(segments, LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, readLogSegmentsPromise);
    }

    @Override
    public void onLogStreamDeleted() {
        this.notifyLogStreamDeleted();
    }

    protected void registerListener(@Nullable LogSegmentListener listener) {
        if (null != listener) {
            this.listeners.add(listener);
        }
    }

    protected void unregisterListener(@Nullable LogSegmentListener listener) {
        if (null != listener) {
            this.listeners.remove(listener);
        }
    }

    protected void notifyUpdatedLogSegments(List<LogSegmentMetadata> segments) {
        if (this.logSegmentsNotificationDisabled) {
            return;
        }
        for (LogSegmentListener listener : this.listeners) {
            ArrayList<LogSegmentMetadata> listToReturn = new ArrayList<LogSegmentMetadata>(segments);
            Collections.sort(listToReturn, LogSegmentMetadata.COMPARATOR);
            listener.onSegmentsUpdated(listToReturn);
        }
    }

    protected void notifyLogStreamDeleted() {
        if (this.logSegmentsNotificationDisabled) {
            return;
        }
        for (LogSegmentListener listener : this.listeners) {
            listener.onLogStreamDeleted();
        }
    }

    protected void notifyReaderOnError(Throwable cause) {
        if (null != this.readerStateNotification) {
            this.readerStateNotification.notifyOnError(cause);
        }
    }
}

