/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1CrossVersionObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="specification of a horizontal pod autoscaler.")
public class V1HorizontalPodAutoscalerSpec {
    public static final String SERIALIZED_NAME_MAX_REPLICAS = "maxReplicas";
    @SerializedName(value="maxReplicas")
    private Integer maxReplicas;
    public static final String SERIALIZED_NAME_MIN_REPLICAS = "minReplicas";
    @SerializedName(value="minReplicas")
    private Integer minReplicas;
    public static final String SERIALIZED_NAME_SCALE_TARGET_REF = "scaleTargetRef";
    @SerializedName(value="scaleTargetRef")
    private V1CrossVersionObjectReference scaleTargetRef;
    public static final String SERIALIZED_NAME_TARGET_C_P_U_UTILIZATION_PERCENTAGE = "targetCPUUtilizationPercentage";
    @SerializedName(value="targetCPUUtilizationPercentage")
    private Integer targetCPUUtilizationPercentage;

    public V1HorizontalPodAutoscalerSpec maxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.")
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public V1HorizontalPodAutoscalerSpec minReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.")
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public V1HorizontalPodAutoscalerSpec scaleTargetRef(V1CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    public void setScaleTargetRef(V1CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    public V1HorizontalPodAutoscalerSpec targetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.")
    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    public void setTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HorizontalPodAutoscalerSpec v1HorizontalPodAutoscalerSpec = (V1HorizontalPodAutoscalerSpec)o;
        return Objects.equals(this.maxReplicas, v1HorizontalPodAutoscalerSpec.maxReplicas) && Objects.equals(this.minReplicas, v1HorizontalPodAutoscalerSpec.minReplicas) && Objects.equals(this.scaleTargetRef, v1HorizontalPodAutoscalerSpec.scaleTargetRef) && Objects.equals(this.targetCPUUtilizationPercentage, v1HorizontalPodAutoscalerSpec.targetCPUUtilizationPercentage);
    }

    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.minReplicas, this.scaleTargetRef, this.targetCPUUtilizationPercentage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HorizontalPodAutoscalerSpec {\n");
        sb.append("    maxReplicas: ").append(this.toIndentedString(this.maxReplicas)).append("\n");
        sb.append("    minReplicas: ").append(this.toIndentedString(this.minReplicas)).append("\n");
        sb.append("    scaleTargetRef: ").append(this.toIndentedString(this.scaleTargetRef)).append("\n");
        sb.append("    targetCPUUtilizationPercentage: ").append(this.toIndentedString(this.targetCPUUtilizationPercentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

