/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.")
public class V1QuobyteVolumeSource {
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_REGISTRY = "registry";
    @SerializedName(value="registry")
    private String registry;
    public static final String SERIALIZED_NAME_TENANT = "tenant";
    @SerializedName(value="tenant")
    private String tenant;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;
    public static final String SERIALIZED_NAME_VOLUME = "volume";
    @SerializedName(value="volume")
    private String volume;

    public V1QuobyteVolumeSource group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="group to map volume access to Default is no group")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public V1QuobyteVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1QuobyteVolumeSource registry(String registry) {
        this.registry = registry;
        return this;
    }

    @ApiModelProperty(required=true, value="registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes")
    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public V1QuobyteVolumeSource tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin")
    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public V1QuobyteVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="user to map volume access to Defaults to serivceaccount user")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public V1QuobyteVolumeSource volume(String volume) {
        this.volume = volume;
        return this;
    }

    @ApiModelProperty(required=true, value="volume is a string that references an already created Quobyte volume by name.")
    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1QuobyteVolumeSource v1QuobyteVolumeSource = (V1QuobyteVolumeSource)o;
        return Objects.equals(this.group, v1QuobyteVolumeSource.group) && Objects.equals(this.readOnly, v1QuobyteVolumeSource.readOnly) && Objects.equals(this.registry, v1QuobyteVolumeSource.registry) && Objects.equals(this.tenant, v1QuobyteVolumeSource.tenant) && Objects.equals(this.user, v1QuobyteVolumeSource.user) && Objects.equals(this.volume, v1QuobyteVolumeSource.volume);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.readOnly, this.registry, this.tenant, this.user, this.volume);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1QuobyteVolumeSource {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString(this.registry)).append("\n");
        sb.append("    tenant: ").append(this.toIndentedString(this.tenant)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString(this.volume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

