/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ReplicaSetSpec is the specification of a ReplicaSet.")
public class V1ReplicaSetSpec {
    public static final String SERIALIZED_NAME_MIN_READY_SECONDS = "minReadySeconds";
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;

    public V1ReplicaSetSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1ReplicaSetSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicaSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1ReplicaSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicaSetSpec v1ReplicaSetSpec = (V1ReplicaSetSpec)o;
        return Objects.equals(this.minReadySeconds, v1ReplicaSetSpec.minReadySeconds) && Objects.equals(this.replicas, v1ReplicaSetSpec.replicas) && Objects.equals(this.selector, v1ReplicaSetSpec.selector) && Objects.equals(this.template, v1ReplicaSetSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ReplicaSetSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

