/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.zk.ZKWatcherManager;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.junit.Assert;
import org.junit.Test;

public class TestZKWatcherManager {
    @Test(timeout=60000L)
    public void testRegisterUnregisterWatcher() throws Exception {
        ZKWatcherManager watcherManager = ZKWatcherManager.newBuilder().name("test-register-unregister-watcher").zkc(null).statsLogger((StatsLogger)NullStatsLogger.INSTANCE).build();
        String path = "/test-register-unregister-watcher";
        final LinkedList events = new LinkedList();
        final CountDownLatch latch = new CountDownLatch(2);
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent event) {
                events.add(event);
                latch.countDown();
            }
        };
        watcherManager.registerChildWatcher(path, watcher);
        WatchedEvent event0 = new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path);
        WatchedEvent event1 = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.SyncConnected, path);
        WatchedEvent event2 = new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, path);
        watcher.process(event1);
        watcher.process(event2);
        latch.await();
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertEquals((Object)event1, events.get(0));
        Assert.assertEquals((Object)event2, events.get(1));
        watcherManager.unregisterChildWatcher(path, watcher, true);
        watcherManager.unregisterGauges();
        Assert.assertEquals((long)0L, (long)watcherManager.childWatches.size());
    }
}

