/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import io.streamnative.oxia.client.grpc.OxiaStub;
import io.streamnative.oxia.client.grpc.OxiaStubManager;
import io.streamnative.oxia.client.grpc.OxiaWriteStreamManager;
import io.streamnative.oxia.client.grpc.WriteStreamWrapper;
import io.streamnative.oxia.client.shard.ShardManager;

public class OxiaStubProvider {
    private final String namespace;
    private final OxiaStubManager stubManager;
    private final ShardManager shardManager;
    private final OxiaWriteStreamManager writeStreamManager;

    public OxiaStubProvider(String namespace, OxiaStubManager stubManager, ShardManager shardManager) {
        this.namespace = namespace;
        this.stubManager = stubManager;
        this.shardManager = shardManager;
        this.writeStreamManager = new OxiaWriteStreamManager(this);
    }

    public OxiaStub getStubForShard(long shardId) {
        String leader = this.shardManager.leader(shardId);
        return this.stubManager.getStub(leader);
    }

    public WriteStreamWrapper getWriteStreamForShard(long shardId) {
        return this.writeStreamManager.getWriteStream(shardId);
    }

    public String getNamespace() {
        return this.namespace;
    }
}

