/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.util.Date;
import java.util.Map;

class ImmutableJwtParser
implements JwtParser {
    private final JwtParser jwtParser;

    ImmutableJwtParser(JwtParser jwtParser) {
        this.jwtParser = jwtParser;
    }

    private IllegalStateException doNotMutate() {
        return new IllegalStateException("Cannot mutate a JwtParser created from JwtParserBuilder.build(), the mutable methods in JwtParser will be removed before version 1.0");
    }

    public JwtParser requireId(String id) {
        throw this.doNotMutate();
    }

    public JwtParser requireSubject(String subject) {
        throw this.doNotMutate();
    }

    public JwtParser requireAudience(String audience) {
        throw this.doNotMutate();
    }

    public JwtParser requireIssuer(String issuer) {
        throw this.doNotMutate();
    }

    public JwtParser requireIssuedAt(Date issuedAt) {
        throw this.doNotMutate();
    }

    public JwtParser requireExpiration(Date expiration) {
        throw this.doNotMutate();
    }

    public JwtParser requireNotBefore(Date notBefore) {
        throw this.doNotMutate();
    }

    public JwtParser require(String claimName, Object value) {
        throw this.doNotMutate();
    }

    public JwtParser setClock(Clock clock) {
        throw this.doNotMutate();
    }

    public JwtParser setAllowedClockSkewSeconds(long seconds) {
        throw this.doNotMutate();
    }

    public JwtParser setSigningKey(byte[] key) {
        throw this.doNotMutate();
    }

    public JwtParser setSigningKey(String base64EncodedSecretKey) {
        throw this.doNotMutate();
    }

    public JwtParser setSigningKey(Key key) {
        throw this.doNotMutate();
    }

    public JwtParser setSigningKeyResolver(SigningKeyResolver signingKeyResolver) {
        throw this.doNotMutate();
    }

    public JwtParser setCompressionCodecResolver(CompressionCodecResolver compressionCodecResolver) {
        throw this.doNotMutate();
    }

    public JwtParser base64UrlDecodeWith(Decoder<String, byte[]> base64UrlDecoder) {
        throw this.doNotMutate();
    }

    public JwtParser deserializeJsonWith(Deserializer<Map<String, ?>> deserializer) {
        throw this.doNotMutate();
    }

    public boolean isSigned(String jwt) {
        return this.jwtParser.isSigned(jwt);
    }

    public Jwt parse(String jwt) throws ExpiredJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return this.jwtParser.parse(jwt);
    }

    public <T> T parse(String jwt, JwtHandler<T> handler) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return (T)this.jwtParser.parse(jwt, handler);
    }

    public Jwt<Header, String> parsePlaintextJwt(String plaintextJwt) throws UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return this.jwtParser.parsePlaintextJwt(plaintextJwt);
    }

    public Jwt<Header, Claims> parseClaimsJwt(String claimsJwt) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return this.jwtParser.parseClaimsJwt(claimsJwt);
    }

    public Jws<String> parsePlaintextJws(String plaintextJws) throws UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return this.jwtParser.parsePlaintextJws(plaintextJws);
    }

    public Jws<Claims> parseClaimsJws(String claimsJws) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return this.jwtParser.parseClaimsJws(claimsJws);
    }
}

