/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;

public class ConcurrentConfiguration
extends AbstractConfiguration {
    private final ConcurrentMap<String, Object> map;

    public ConcurrentConfiguration() {
        this.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.map = new ConcurrentHashMap<String, Object>();
    }

    protected void addPropertyDirect(String key, Object value) {
        Preconditions.checkNotNull((Object)value);
        this.map.put(key, value);
    }

    public Object getPropertyInternal(String key) {
        return this.map.get(key);
    }

    public Iterator getKeysInternal() {
        return this.map.keySet().iterator();
    }

    public boolean containsKeyInternal(String key) {
        return this.map.containsKey(key);
    }

    protected boolean containsValueInternal(Object o) {
        return this.map.containsValue(o);
    }

    public boolean isEmptyInternal() {
        return this.map.isEmpty();
    }

    protected void clearPropertyDirect(String key) {
        this.map.remove(key);
    }
}

