/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.DefaultParametersManager;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class ConfigurationUtil {
    public static PropertiesConfiguration newConfiguration(Function<Configurations, FileBasedConfigurationBuilder<PropertiesConfiguration>> builderFunction) throws ConfigurationException {
        DefaultParametersManager parametersManager = new DefaultParametersManager();
        parametersManager.registerDefaultsHandler(BasicBuilderParameters.class, basicBuilderParameters -> basicBuilderParameters.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(',')));
        Parameters params = new Parameters(parametersManager);
        Configurations configurations = new Configurations(params);
        FileBasedConfigurationBuilder<PropertiesConfiguration> builder = builderFunction.apply(configurations);
        return (PropertiesConfiguration)builder.getConfiguration();
    }

    public static Configuration readSystemPropertiesAsConfiguration() {
        Properties properties = System.getProperties();
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propertiesMap.put(entry.getKey().toString(), entry.getValue());
        }
        return new MapConfiguration(propertiesMap);
    }
}

