/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.NamespaceIsolationPolicy;
import org.apache.pulsar.common.policies.data.BrokerAssignment;
import org.apache.pulsar.common.policies.data.BrokerStatus;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicyImpl;

public class NamespaceIsolationPolicies {
    private Map<String, NamespaceIsolationDataImpl> policies = null;

    public NamespaceIsolationPolicies() {
        this.policies = new HashMap<String, NamespaceIsolationDataImpl>();
    }

    public NamespaceIsolationPolicies(Map<String, NamespaceIsolationDataImpl> policiesMap) {
        this.policies = policiesMap;
    }

    public NamespaceIsolationPolicy getPolicyByName(String policyName) {
        if (this.policies.get(policyName) == null) {
            return null;
        }
        return new NamespaceIsolationPolicyImpl(this.policies.get(policyName));
    }

    public NamespaceIsolationPolicy getPolicyByNamespace(NamespaceName namespace) {
        for (NamespaceIsolationData namespaceIsolationData : this.policies.values()) {
            if (!this.namespaceMatches(namespace, namespaceIsolationData)) continue;
            return new NamespaceIsolationPolicyImpl(namespaceIsolationData);
        }
        return null;
    }

    private boolean namespaceMatches(NamespaceName namespace, NamespaceIsolationData nsPolicyData) {
        for (String nsnameRegex : nsPolicyData.getNamespaces()) {
            if (!namespace.toString().matches(nsnameRegex)) continue;
            return true;
        }
        return false;
    }

    public void setPolicy(String policyName, NamespaceIsolationData policyData) {
        policyData.validate();
        this.policies.put(policyName, (NamespaceIsolationDataImpl)policyData);
    }

    public void deletePolicy(String policyName) {
        this.policies.remove(policyName);
    }

    public Map<String, NamespaceIsolationDataImpl> getPolicies() {
        return this.policies;
    }

    public boolean isSharedBroker(String host) {
        for (NamespaceIsolationData namespaceIsolationData : this.policies.values()) {
            NamespaceIsolationPolicyImpl policy = new NamespaceIsolationPolicyImpl(namespaceIsolationData);
            if (!policy.isPrimaryBroker(host)) continue;
            return false;
        }
        return true;
    }

    private BrokerAssignment getBrokerAssignment(NamespaceIsolationPolicy nsPolicy, String brokerAddress) {
        if (nsPolicy != null) {
            if (nsPolicy.isPrimaryBroker(brokerAddress)) {
                return BrokerAssignment.primary;
            }
            if (nsPolicy.isSecondaryBroker(brokerAddress)) {
                return BrokerAssignment.secondary;
            }
            throw new IllegalArgumentException("The broker " + brokerAddress + " is not among the assigned broker pools for the controlled namespace.");
        }
        if (!this.isSharedBroker(brokerAddress)) {
            throw new IllegalArgumentException("The broker " + brokerAddress + " is not among the shared broker pools for the uncontrolled namespace.");
        }
        return BrokerAssignment.shared;
    }

    public void assignBroker(NamespaceName nsname, BrokerStatus brkStatus, SortedSet<BrokerStatus> primaryCandidates, SortedSet<BrokerStatus> secondaryCandidates, SortedSet<BrokerStatus> sharedCandidates) {
        NamespaceIsolationPolicy nsPolicy = this.getPolicyByNamespace(nsname);
        BrokerAssignment brokerAssignment = this.getBrokerAssignment(nsPolicy, brkStatus.getBrokerAddress());
        if (brokerAssignment == BrokerAssignment.primary) {
            if (nsPolicy != null && nsPolicy.isPrimaryBrokerAvailable(brkStatus)) {
                primaryCandidates.add(brkStatus);
            }
        } else if (brokerAssignment == BrokerAssignment.secondary) {
            secondaryCandidates.add(brkStatus);
        } else if (brokerAssignment == BrokerAssignment.shared) {
            sharedCandidates.add(brkStatus);
        }
    }
}

