/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.filter;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLoadData;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerFilter;
import org.apache.pulsar.common.naming.ServiceUnitId;

public class BrokerMaxTopicCountFilter
implements BrokerFilter {
    public static final String FILTER_NAME = "broker_max_topic_count_filter";

    @Override
    public String name() {
        return FILTER_NAME;
    }

    @Override
    public CompletableFuture<Map<String, BrokerLookupData>> filterAsync(Map<String, BrokerLookupData> brokers, ServiceUnitId serviceUnit, LoadManagerContext context) {
        int loadBalancerBrokerMaxTopics = context.brokerConfiguration().getLoadBalancerBrokerMaxTopics();
        brokers.keySet().removeIf(broker -> {
            Optional<BrokerLoadData> brokerLoadDataOpt;
            try {
                brokerLoadDataOpt = context.brokerLoadDataStore().get((String)broker);
            }
            catch (IllegalStateException ignored) {
                return false;
            }
            long topics = brokerLoadDataOpt.map(BrokerLoadData::getTopics).orElse(0L);
            return topics >= (long)loadBalancerBrokerMaxTopics;
        });
        return CompletableFuture.completedFuture(brokers);
    }
}

