/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.LoadSheddingStrategy;
import org.apache.pulsar.broker.loadbalance.ModularLoadManagerStrategy;
import org.apache.pulsar.policies.data.loadbalancer.BrokerData;
import org.apache.pulsar.policies.data.loadbalancer.BundleData;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.apache.pulsar.policies.data.loadbalancer.TimeAverageMessageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvgShedder
implements LoadSheddingStrategy,
ModularLoadManagerStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvgShedder.class);
    private final Map<BundleData, String> bundleBrokerMap = new HashMap<BundleData, String>();
    private final Map<String, Double> brokerScoreMap = new HashMap<String, Double>();
    private final Map<String, MutableInt> brokerHitCountForHigh = new HashMap<String, MutableInt>();
    private final Map<String, MutableInt> brokerHitCountForLow = new HashMap<String, MutableInt>();
    private static final double MB = 1048576.0;

    @Override
    public Multimap<String, String> findBundlesForUnloading(LoadData loadData, ServiceConfiguration conf) {
        ArrayListMultimap selectedBundlesCache = ArrayListMultimap.create();
        double minThroughputThreshold = conf.getMinUnloadMessageThroughput();
        double minMsgThreshold = conf.getMinUnloadMessage();
        double maxUnloadPercentage = conf.getMaxUnloadPercentage();
        double lowThreshold = conf.getLoadBalancerAvgShedderLowThreshold();
        double highThreshold = conf.getLoadBalancerAvgShedderHighThreshold();
        int hitCountHighThreshold = conf.getLoadBalancerAvgShedderHitCountHighThreshold();
        int hitCountLowThreshold = conf.getLoadBalancerAvgShedderHitCountLowThreshold();
        if (log.isDebugEnabled()) {
            log.debug("highThreshold:{}, lowThreshold:{}, hitCountHighThreshold:{}, hitCountLowThreshold:{}, minMsgThreshold:{}, minThroughputThreshold:{}", new Object[]{highThreshold, lowThreshold, hitCountHighThreshold, hitCountLowThreshold, minMsgThreshold, minThroughputThreshold});
        }
        List<String> brokers = this.calculateScoresAndSort(loadData, conf);
        log.info("sorted broker list:{}", brokers);
        List<Pair<String, String>> pairs = this.findBrokerPairs(brokers, lowThreshold, highThreshold);
        log.info("brokerHitCountForHigh:{}, brokerHitCountForLow:{}", this.brokerHitCountForHigh, this.brokerHitCountForLow);
        if (pairs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("there is no any overload broker, no need to shedding bundles.");
            }
            this.brokerHitCountForHigh.clear();
            this.brokerHitCountForLow.clear();
            return selectedBundlesCache;
        }
        for (Pair<String, String> pair : pairs) {
            String overloadedBroker = (String)pair.getRight();
            String underloadedBroker = (String)pair.getLeft();
            if (this.brokerHitCountForHigh.computeIfAbsent(underloadedBroker, __ -> new MutableInt(0)).intValue() < hitCountHighThreshold && this.brokerHitCountForHigh.computeIfAbsent(overloadedBroker, __ -> new MutableInt(0)).intValue() < hitCountHighThreshold && this.brokerHitCountForLow.computeIfAbsent(underloadedBroker, __ -> new MutableInt(0)).intValue() < hitCountLowThreshold && this.brokerHitCountForLow.computeIfAbsent(overloadedBroker, __ -> new MutableInt(0)).intValue() < hitCountLowThreshold) continue;
            this.brokerHitCountForHigh.remove(underloadedBroker);
            this.brokerHitCountForHigh.remove(overloadedBroker);
            this.brokerHitCountForLow.remove(underloadedBroker);
            this.brokerHitCountForLow.remove(overloadedBroker);
            this.selectBundleForUnloading(loadData, overloadedBroker, underloadedBroker, minThroughputThreshold, minMsgThreshold, maxUnloadPercentage, (Multimap<String, String>)selectedBundlesCache);
        }
        return selectedBundlesCache;
    }

    private void selectBundleForUnloading(LoadData loadData, String overloadedBroker, String underloadedBroker, double minThroughputThreshold, double minMsgThreshold, double maxUnloadPercentage, Multimap<String, String> selectedBundlesCache) {
        boolean isMsgRateToOffload;
        LocalBrokerData minLocalBrokerData = loadData.getBrokerData().get(underloadedBroker).getLocalData();
        LocalBrokerData maxLocalBrokerData = loadData.getBrokerData().get(overloadedBroker).getLocalData();
        double minMsgRate = minLocalBrokerData.getMsgRateIn() + minLocalBrokerData.getMsgRateOut();
        double maxMsgRate = maxLocalBrokerData.getMsgRateIn() + maxLocalBrokerData.getMsgRateOut();
        double minThroughput = minLocalBrokerData.getMsgThroughputIn() + minLocalBrokerData.getMsgThroughputOut();
        double maxThroughput = maxLocalBrokerData.getMsgThroughputIn() + maxLocalBrokerData.getMsgThroughputOut();
        double msgRequiredFromUnloadedBundles = (maxMsgRate - minMsgRate) * maxUnloadPercentage;
        double throughputRequiredFromUnloadedBundles = (maxThroughput - minThroughput) * maxUnloadPercentage;
        MutableDouble trafficMarkedToOffload = new MutableDouble(0.0);
        if (msgRequiredFromUnloadedBundles > minMsgThreshold) {
            isMsgRateToOffload = true;
            trafficMarkedToOffload.setValue(msgRequiredFromUnloadedBundles);
        } else if (throughputRequiredFromUnloadedBundles > minThroughputThreshold) {
            isMsgRateToOffload = false;
            trafficMarkedToOffload.setValue(throughputRequiredFromUnloadedBundles);
        } else {
            log.info("broker:[{}] is planning to shed bundles to broker:[{}],but the throughput {} MByte/s is less than minimumThroughputThreshold {} MByte/s, and the msgRate {} rate/s is also less than minimumMsgRateThreshold {} rate/s, skipping bundle unload.", new Object[]{overloadedBroker, underloadedBroker, throughputRequiredFromUnloadedBundles / 1048576.0, minThroughputThreshold / 1048576.0, msgRequiredFromUnloadedBundles, minMsgThreshold});
            return;
        }
        if (maxLocalBrokerData.getBundles().size() == 1) {
            log.warn("HIGH USAGE WARNING : Sole namespace bundle {} is overloading broker {}. No Load Shedding will be done on this broker", maxLocalBrokerData.getBundles().iterator().next(), (Object)overloadedBroker);
        } else if (maxLocalBrokerData.getBundles().isEmpty()) {
            log.warn("Broker {} is overloaded despite having no bundles", (Object)overloadedBroker);
        }
        log.info("broker:[{}] is planning to shed bundles to broker:[{}]. maxBroker stat:scores:{}, throughput:{}, msgRate:{}. minBroker stat:scores:{}, throughput:{}, msgRate:{}. isMsgRateToOffload:{},  trafficMarkedToOffload:{}", new Object[]{overloadedBroker, underloadedBroker, this.brokerScoreMap.get(overloadedBroker), maxThroughput, maxMsgRate, this.brokerScoreMap.get(underloadedBroker), minThroughput, minMsgRate, isMsgRateToOffload, trafficMarkedToOffload});
        loadData.getBundleDataForLoadShedding().entrySet().stream().filter(e -> maxLocalBrokerData.getBundles().contains(e.getKey())).filter(e -> !loadData.getRecentlyUnloadedBundles().containsKey(e.getKey())).map(e -> {
            BundleData bundleData = (BundleData)e.getValue();
            TimeAverageMessageData shortTermData = bundleData.getShortTermData();
            double traffic = isMsgRateToOffload ? shortTermData.getMsgRateIn() + shortTermData.getMsgRateOut() : shortTermData.getMsgThroughputIn() + shortTermData.getMsgThroughputOut();
            return Pair.of((Object)e, (Object)traffic);
        }).sorted((e1, e2) -> Double.compare((Double)e2.getRight(), (Double)e1.getRight())).forEach(e -> {
            Map.Entry bundle = (Map.Entry)e.getLeft();
            double traffic = (Double)e.getRight();
            if (traffic > 0.0 && traffic <= trafficMarkedToOffload.getValue()) {
                selectedBundlesCache.put((Object)overloadedBroker, (Object)((String)bundle.getKey()));
                this.bundleBrokerMap.put((BundleData)bundle.getValue(), underloadedBroker);
                trafficMarkedToOffload.add(-traffic);
                if (log.isDebugEnabled()) {
                    log.debug("Found bundle to unload:{}, isMsgRateToOffload:{}, traffic:{}", new Object[]{bundle, isMsgRateToOffload, traffic});
                }
            }
        });
    }

    @Override
    public void onActiveBrokersChange(Set<String> activeBrokers) {
        LoadSheddingStrategy.super.onActiveBrokersChange(activeBrokers);
    }

    private List<String> calculateScoresAndSort(LoadData loadData, ServiceConfiguration conf) {
        this.brokerScoreMap.clear();
        for (Map.Entry<String, BrokerData> entry : loadData.getBrokerData().entrySet()) {
            LocalBrokerData localBrokerData = entry.getValue().getLocalData();
            String broker = entry.getKey();
            Double score = this.calculateScores(localBrokerData, conf);
            this.brokerScoreMap.put(broker, score);
            if (!log.isDebugEnabled()) continue;
            log.info("broker:{}, scores:{}, throughput:{}, messageRate:{}", new Object[]{broker, score, localBrokerData.getMsgThroughputIn() + localBrokerData.getMsgThroughputOut(), localBrokerData.getMsgRateIn() + localBrokerData.getMsgRateOut()});
        }
        return this.brokerScoreMap.entrySet().stream().sorted((o1, o2) -> (int)((Double)o1.getValue() - (Double)o2.getValue())).map(Map.Entry::getKey).toList();
    }

    private Double calculateScores(LocalBrokerData localBrokerData, ServiceConfiguration conf) {
        return localBrokerData.getMaxResourceUsageWithWeight(conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwidthInResourceWeight(), conf.getLoadBalancerBandwidthOutResourceWeight()) * 100.0;
    }

    private List<Pair<String, String>> findBrokerPairs(List<String> brokers, double lowThreshold, double highThreshold) {
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        int i = 0;
        for (int j = brokers.size() - 1; i <= j; ++i, --j) {
            String maxBroker = brokers.get(j);
            String minBroker = brokers.get(i);
            if (this.brokerScoreMap.get(maxBroker) - this.brokerScoreMap.get(minBroker) < lowThreshold) {
                this.brokerHitCountForHigh.remove(maxBroker);
                this.brokerHitCountForHigh.remove(minBroker);
                this.brokerHitCountForLow.remove(maxBroker);
                this.brokerHitCountForLow.remove(minBroker);
                continue;
            }
            pairs.add((Pair<String, String>)Pair.of((Object)minBroker, (Object)maxBroker));
            if (this.brokerScoreMap.get(maxBroker) - this.brokerScoreMap.get(minBroker) < highThreshold) {
                this.brokerHitCountForLow.computeIfAbsent(minBroker, k -> new MutableInt(0)).increment();
                this.brokerHitCountForLow.computeIfAbsent(maxBroker, k -> new MutableInt(0)).increment();
                this.brokerHitCountForHigh.remove(maxBroker);
                this.brokerHitCountForHigh.remove(minBroker);
                continue;
            }
            this.brokerHitCountForLow.computeIfAbsent(minBroker, k -> new MutableInt(0)).increment();
            this.brokerHitCountForLow.computeIfAbsent(maxBroker, k -> new MutableInt(0)).increment();
            this.brokerHitCountForHigh.computeIfAbsent(minBroker, k -> new MutableInt(0)).increment();
            this.brokerHitCountForHigh.computeIfAbsent(maxBroker, k -> new MutableInt(0)).increment();
        }
        return pairs;
    }

    @Override
    public Optional<String> selectBroker(Set<String> candidates, BundleData bundleToAssign, LoadData loadData, ServiceConfiguration conf) {
        String brokerToUnload = this.bundleBrokerMap.getOrDefault(bundleToAssign, null);
        if (brokerToUnload == null || !candidates.contains(this.bundleBrokerMap.get(bundleToAssign))) {
            if (log.isDebugEnabled()) {
                if (!this.bundleBrokerMap.containsKey(bundleToAssign)) {
                    log.debug("cluster is initializing");
                } else {
                    log.debug("expected broker:{} is shutdown, candidates:{}", (Object)this.bundleBrokerMap.get(bundleToAssign), candidates);
                }
            }
            String broker = AvgShedder.getExpectedBroker(candidates, bundleToAssign);
            this.bundleBrokerMap.put(bundleToAssign, broker);
            return Optional.of(broker);
        }
        return Optional.of(brokerToUnload);
    }

    private static String getExpectedBroker(Collection<String> brokers, BundleData bundle) {
        ArrayList<String> sortedBrokers = new ArrayList<String>(brokers);
        Collections.sort(sortedBrokers);
        try {
            long hashcode = Hashing.crc32().hashString((CharSequence)String.valueOf(new Random().nextInt()), StandardCharsets.UTF_8).padToLong();
            int index = (int)(Math.abs(hashcode) % (long)sortedBrokers.size());
            if (log.isDebugEnabled()) {
                log.debug("Assignment details: brokers={}, bundle={}, hashcode={}, index={}", new Object[]{sortedBrokers, bundle, hashcode, index});
            }
            return (String)sortedBrokers.get(index);
        }
        catch (Throwable e) {
            log.error("Bundle format of {} is invalid", (Object)bundle, (Object)e);
            return (String)sortedBrokers.get(Math.abs(bundle.hashCode()) % sortedBrokers.size());
        }
    }
}

