/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.metadata.api.Stat;

public interface MetaStore {
    default public void getManagedLedgerInfo(String ledgerName, boolean createIfMissing, MetaStoreCallback<MLDataFormats.ManagedLedgerInfo> callback) {
        this.getManagedLedgerInfo(ledgerName, createIfMissing, null, callback);
    }

    public void getManagedLedgerInfo(String var1, boolean var2, Map<String, String> var3, MetaStoreCallback<MLDataFormats.ManagedLedgerInfo> var4);

    public void watchManagedLedgerInfo(String var1, UpdateCallback<MLDataFormats.ManagedLedgerInfo> var2);

    public void unwatchManagedLedgerInfo(String var1);

    public void asyncUpdateLedgerIds(String var1, MLDataFormats.ManagedLedgerInfo var2, Stat var3, MetaStoreCallback<Void> var4);

    public void getCursors(String var1, MetaStoreCallback<List<String>> var2);

    public void asyncGetCursorInfo(String var1, String var2, MetaStoreCallback<MLDataFormats.ManagedCursorInfo> var3);

    public void asyncUpdateCursorInfo(String var1, String var2, MLDataFormats.ManagedCursorInfo var3, Stat var4, MetaStoreCallback<Void> var5);

    public void asyncRemoveCursor(String var1, String var2, MetaStoreCallback<Void> var3);

    public void removeManagedLedger(String var1, MetaStoreCallback<Void> var2);

    public Iterable<String> getManagedLedgers() throws ManagedLedgerException.MetaStoreException;

    public CompletableFuture<Boolean> asyncExists(String var1);

    public CompletableFuture<Map<String, String>> getManagedLedgerPropertiesAsync(String var1);

    public static interface MetaStoreCallback<T> {
        public void operationComplete(T var1, Stat var2);

        public void operationFailed(ManagedLedgerException.MetaStoreException var1);
    }

    public static interface UpdateCallback<T> {
        public void onUpdate(T var1, Stat var2);
    }

    public static interface UpdateLedgersIdsCallback {
        public void updateLedgersIdsComplete(ManagedLedgerException.MetaStoreException var1, Stat var2);
    }
}

