/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import io.netty.util.Timer;
import io.prometheus.client.CollectorRegistry;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreProvider;
import org.apache.pulsar.transaction.coordinator.TransactionRecoverTracker;
import org.apache.pulsar.transaction.coordinator.TransactionTimeoutTracker;
import org.apache.pulsar.transaction.coordinator.impl.DisabledTxnLogBufferedWriterMetricsStats;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionLogImpl;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionSequenceIdGenerator;
import org.apache.pulsar.transaction.coordinator.impl.TxnLogBufferedWriterConfig;
import org.apache.pulsar.transaction.coordinator.impl.TxnLogBufferedWriterMetricsStats;

public class MLTransactionMetadataStoreProvider
implements TransactionMetadataStoreProvider {
    private static volatile TxnLogBufferedWriterMetricsStats bufferedWriterMetrics = DisabledTxnLogBufferedWriterMetricsStats.DISABLED_BUFFERED_WRITER_METRICS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initBufferedWriterMetrics(String brokerAdvertisedAddress) {
        if (bufferedWriterMetrics != DisabledTxnLogBufferedWriterMetricsStats.DISABLED_BUFFERED_WRITER_METRICS) {
            return;
        }
        Class<MLTransactionMetadataStoreProvider> clazz = MLTransactionMetadataStoreProvider.class;
        synchronized (MLTransactionMetadataStoreProvider.class) {
            if (bufferedWriterMetrics != DisabledTxnLogBufferedWriterMetricsStats.DISABLED_BUFFERED_WRITER_METRICS) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            bufferedWriterMetrics = new MLTransactionMetadataStoreBufferedWriterMetrics(brokerAdvertisedAddress);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeBufferedWriterMetrics() {
        Class<MLTransactionMetadataStoreProvider> clazz = MLTransactionMetadataStoreProvider.class;
        synchronized (MLTransactionMetadataStoreProvider.class) {
            if (bufferedWriterMetrics == DisabledTxnLogBufferedWriterMetricsStats.DISABLED_BUFFERED_WRITER_METRICS) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            bufferedWriterMetrics.close();
            bufferedWriterMetrics = DisabledTxnLogBufferedWriterMetricsStats.DISABLED_BUFFERED_WRITER_METRICS;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public CompletableFuture<TransactionMetadataStore> openStore(TransactionCoordinatorID transactionCoordinatorId, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig, TransactionTimeoutTracker timeoutTracker, TransactionRecoverTracker recoverTracker, long maxActiveTransactionsPerCoordinator, TxnLogBufferedWriterConfig txnLogBufferedWriterConfig, Timer timer) {
        MLTransactionSequenceIdGenerator mlTransactionSequenceIdGenerator = new MLTransactionSequenceIdGenerator();
        managedLedgerConfig.setManagedLedgerInterceptor((ManagedLedgerInterceptor)mlTransactionSequenceIdGenerator);
        MLTransactionLogImpl txnLog = new MLTransactionLogImpl(transactionCoordinatorId, managedLedgerFactory, managedLedgerConfig, txnLogBufferedWriterConfig, timer, bufferedWriterMetrics);
        return txnLog.initialize().thenCompose(__ -> new MLTransactionMetadataStore(transactionCoordinatorId, txnLog, timeoutTracker, mlTransactionSequenceIdGenerator, maxActiveTransactionsPerCoordinator).init(recoverTracker));
    }

    private static class MLTransactionMetadataStoreBufferedWriterMetrics
    extends TxnLogBufferedWriterMetricsStats {
        private MLTransactionMetadataStoreBufferedWriterMetrics(String brokerAdvertisedAddress) {
            super("pulsar_txn_tc", new String[]{"broker"}, new String[]{brokerAdvertisedAddress}, CollectorRegistry.defaultRegistry);
        }
    }
}

