/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortDoubleAssociativeContainer;
import com.carrotsearch.hppc.ShortDoubleHashMap;
import com.carrotsearch.hppc.ShortDoubleMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.comparators.ShortComparator;
import com.carrotsearch.hppc.comparators.ShortDoubleComparator;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.ShortDoublePredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.ShortDoubleProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationShortDoubleHashMap
implements ShortDoubleMap {
    public final ShortDoubleHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationShortDoubleHashMap(ShortDoubleHashMap delegate, ShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortDoubleHashMap(ShortDoubleHashMap delegate, ShortDoubleComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortDoubleComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final double[] values;
            {
                this.keys = SortedIterationShortDoubleHashMap.this.delegate.keys;
                this.values = SortedIterationShortDoubleHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortDoubleCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortDoublePredicate predicate) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortDoubleProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortDoublePredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public double get(short key) {
        return this.delegate.get(key);
    }

    @Override
    public double getOrDefault(short key, double defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public double put(short key, double value) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortDoubleAssociativeContainer container) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortDoubleCursor> iterable) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public double putOrAdd(short key, double putValue, double incrementValue) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public double addTo(short key, double additionValue) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public double remove(short key) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public double indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public double indexReplace(int index, double newValue) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key, double value) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public double indexRemove(int index) {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortDoubleHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortDoubleCursor> {
        private final ShortDoubleCursor cursor = new ShortDoubleCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortDoubleCursor fetch() {
            if (this.index < SortedIterationShortDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortDoubleHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortDoubleCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortDoubleHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationShortDoubleHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final SortedIterationShortDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortDoubleHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            for (ShortDoubleCursor c : this.owner) {
                if (Double.doubleToLongBits(value) != Double.doubleToLongBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(double e) {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.index < SortedIterationShortDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortDoubleHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

