/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.grpc;

import io.grpc.stub.StreamObserver;
import io.oxia.proto.OxiaClientGrpc;
import io.oxia.proto.WriteRequest;
import io.oxia.proto.WriteResponse;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteStreamWrapper
implements StreamObserver<WriteResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WriteStreamWrapper.class);
    private final StreamObserver<WriteRequest> clientStream;
    private final Deque<CompletableFuture<WriteResponse>> pendingWrites = new ArrayDeque<CompletableFuture<WriteResponse>>();
    private volatile boolean completed = false;
    private volatile Throwable completedException = null;

    public WriteStreamWrapper(OxiaClientGrpc.OxiaClientStub stub) {
        this.clientStream = stub.writeStream(this);
    }

    public boolean isValid() {
        return !this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(WriteResponse value) {
        WriteStreamWrapper writeStreamWrapper = this;
        synchronized (writeStreamWrapper) {
            CompletableFuture<WriteResponse> future = this.pendingWrites.poll();
            if (future != null) {
                future.complete(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable error) {
        WriteStreamWrapper writeStreamWrapper = this;
        synchronized (writeStreamWrapper) {
            this.completedException = error;
            this.completed = true;
            if (!this.pendingWrites.isEmpty()) {
                log.warn("Receive error when writing data to server through the stream, prepare to fail pending requests. pendingWrites={} {}", (Object)this.pendingWrites.size(), (Object)this.completedException.getMessage());
            }
            this.pendingWrites.forEach(f -> f.completeExceptionally(this.completedException));
            this.pendingWrites.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        WriteStreamWrapper writeStreamWrapper = this;
        synchronized (writeStreamWrapper) {
            this.completed = true;
            if (!this.pendingWrites.isEmpty()) {
                log.info("Receive stream close signal when writing data to server through the stream, prepare to cancel pending requests. pendingWrites={}", (Object)this.pendingWrites.size());
            }
            this.pendingWrites.forEach(f -> f.completeExceptionally(new CancellationException()));
            this.pendingWrites.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<WriteResponse> send(WriteRequest request) {
        if (this.completed) {
            return CompletableFuture.failedFuture(Optional.ofNullable(this.completedException).orElseGet(CancellationException::new));
        }
        WriteStreamWrapper writeStreamWrapper = this;
        synchronized (writeStreamWrapper) {
            if (this.completed) {
                return CompletableFuture.failedFuture(Optional.ofNullable(this.completedException).orElseGet(CancellationException::new));
            }
            CompletableFuture<WriteResponse> future = new CompletableFuture<WriteResponse>();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Sending request {}", (Object)request);
                }
                this.clientStream.onNext((Object)request);
                this.pendingWrites.add(future);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return future;
        }
    }
}

