/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableDistinct<T, K>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final Supplier<? extends Collection<? super K>> collectionSupplier;

    public FlowableDistinct(Flowable<T> source, Function<? super T, K> keySelector, Supplier<? extends Collection<? super K>> collectionSupplier) {
        super(source);
        this.keySelector = keySelector;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> subscriber) {
        Collection<? super K> collection;
        try {
            collection = ExceptionHelper.nullCheck(this.collectionSupplier.get(), "The collectionSupplier returned a null Collection.");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, subscriber);
            return;
        }
        this.source.subscribe(new DistinctSubscriber<T, K>(subscriber, this.keySelector, collection));
    }

    static final class DistinctSubscriber<T, K>
    extends BasicFuseableSubscriber<T, T> {
        final Collection<? super K> collection;
        final Function<? super T, K> keySelector;

        DistinctSubscriber(Subscriber<? super T> actual, Function<? super T, K> keySelector, Collection<? super K> collection) {
            super(actual);
            this.keySelector = keySelector;
            this.collection = collection;
        }

        public void onNext(T value) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0) {
                boolean b;
                try {
                    K key = Objects.requireNonNull(this.keySelector.apply(value), "The keySelector returned a null key");
                    b = this.collection.add(key);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                    return;
                }
                if (b) {
                    this.downstream.onNext(value);
                } else {
                    this.upstream.request(1L);
                }
            } else {
                this.downstream.onNext(null);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
            } else {
                this.done = true;
                this.collection.clear();
                this.downstream.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.collection.clear();
                this.downstream.onComplete();
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qs.poll()) != null && !this.collection.add(Objects.requireNonNull(this.keySelector.apply(v), "The keySelector returned a null key"))) {
                if (this.sourceMode != 2) continue;
                this.upstream.request(1L);
            }
            return v;
        }

        @Override
        public void clear() {
            this.collection.clear();
            super.clear();
        }
    }
}

