/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.log4j2;

import io.prometheus.client.Counter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Prometheus", category="Core", elementType="appender")
public final class InstrumentedAppender
extends AbstractAppender {
    public static final String COUNTER_NAME = "log4j2_appender_total";
    private static final Counter COUNTER = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("log4j2_appender_total")).help("Log4j2 log statements at various log levels")).labelNames(new String[]{"level"})).register();
    private static final Counter.Child TRACE_LABEL = (Counter.Child)COUNTER.labels(new String[]{"trace"});
    private static final Counter.Child DEBUG_LABEL = (Counter.Child)COUNTER.labels(new String[]{"debug"});
    private static final Counter.Child INFO_LABEL = (Counter.Child)COUNTER.labels(new String[]{"info"});
    private static final Counter.Child WARN_LABEL = (Counter.Child)COUNTER.labels(new String[]{"warn"});
    private static final Counter.Child ERROR_LABEL = (Counter.Child)COUNTER.labels(new String[]{"error"});
    private static final Counter.Child FATAL_LABEL = (Counter.Child)COUNTER.labels(new String[]{"fatal"});

    protected InstrumentedAppender(String name) {
        super(name, null, null);
    }

    public void append(LogEvent event) {
        Level level = event.getLevel();
        if (Level.TRACE.equals((Object)level)) {
            TRACE_LABEL.inc();
        } else if (Level.DEBUG.equals((Object)level)) {
            DEBUG_LABEL.inc();
        } else if (Level.INFO.equals((Object)level)) {
            INFO_LABEL.inc();
        } else if (Level.WARN.equals((Object)level)) {
            WARN_LABEL.inc();
        } else if (Level.ERROR.equals((Object)level)) {
            ERROR_LABEL.inc();
        } else if (Level.FATAL.equals((Object)level)) {
            FATAL_LABEL.inc();
        }
    }

    @PluginFactory
    public static InstrumentedAppender createAppender(@PluginAttribute(value="name") String name) {
        if (name == null) {
            LOGGER.error("No name provided for InstrumentedAppender");
            return null;
        }
        return new InstrumentedAppender(name);
    }
}

