/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.policies.data.loadbalancer;

import lombok.Generated;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.policies.data.loadbalancer.TimeAverageMessageData;

public class BundleData
implements Comparable<BundleData> {
    private TimeAverageMessageData shortTermData;
    private TimeAverageMessageData longTermData;
    private int topics;

    public BundleData() {
    }

    public BundleData(int numShortSamples, int numLongSamples) {
        this.shortTermData = new TimeAverageMessageData(numShortSamples);
        this.longTermData = new TimeAverageMessageData(numLongSamples);
    }

    public BundleData(int numShortSamples, int numLongSamples, NamespaceBundleStats defaultStats) {
        this.shortTermData = new TimeAverageMessageData(numShortSamples, defaultStats);
        this.longTermData = new TimeAverageMessageData(numLongSamples, defaultStats);
    }

    public void update(NamespaceBundleStats newSample) {
        this.shortTermData.update(newSample);
        this.longTermData.update(newSample);
        this.topics = (int)newSample.topics;
    }

    public TimeAverageMessageData getShortTermData() {
        return this.shortTermData;
    }

    public void setShortTermData(TimeAverageMessageData shortTermData) {
        this.shortTermData = shortTermData;
    }

    public TimeAverageMessageData getLongTermData() {
        return this.longTermData;
    }

    public void setLongTermData(TimeAverageMessageData longTermData) {
        this.longTermData = longTermData;
    }

    public int getTopics() {
        return this.topics;
    }

    public void setTopics(int topics) {
        this.topics = topics;
    }

    @Override
    public int compareTo(BundleData o) {
        int result = this.shortTermData.compareTo(o.shortTermData);
        if (result == 0) {
            result = this.longTermData.compareTo(o.longTermData);
        }
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BundleData)) {
            return false;
        }
        BundleData other = (BundleData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTopics() != other.getTopics()) {
            return false;
        }
        TimeAverageMessageData this$shortTermData = this.getShortTermData();
        TimeAverageMessageData other$shortTermData = other.getShortTermData();
        if (this$shortTermData == null ? other$shortTermData != null : !((Object)this$shortTermData).equals(other$shortTermData)) {
            return false;
        }
        TimeAverageMessageData this$longTermData = this.getLongTermData();
        TimeAverageMessageData other$longTermData = other.getLongTermData();
        return !(this$longTermData == null ? other$longTermData != null : !((Object)this$longTermData).equals(other$longTermData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BundleData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTopics();
        TimeAverageMessageData $shortTermData = this.getShortTermData();
        result = result * 59 + ($shortTermData == null ? 43 : ((Object)$shortTermData).hashCode());
        TimeAverageMessageData $longTermData = this.getLongTermData();
        result = result * 59 + ($longTermData == null ? 43 : ((Object)$longTermData).hashCode());
        return result;
    }
}

