/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.pulsar.common.util.BackoffBuilder;
import org.apache.pulsar.metadata.api.CacheGetResult;

public class MetadataCacheConfig<T> {
    private static final long DEFAULT_CACHE_REFRESH_TIME_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    public static final BackoffBuilder DEFAULT_RETRY_BACKOFF_BUILDER = new BackoffBuilder().setInitialTime(5L, TimeUnit.MILLISECONDS).setMax(3L, TimeUnit.SECONDS).setMandatoryStop(30L, TimeUnit.SECONDS);
    public static final BackoffBuilder NO_RETRY_BACKOFF_BUILDER = new BackoffBuilder().setInitialTime(0L, TimeUnit.MILLISECONDS).setMax(0L, TimeUnit.SECONDS).setMandatoryStop(0L, TimeUnit.SECONDS);
    private final long refreshAfterWriteMillis;
    private final long expireAfterWriteMillis;
    private final BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer;
    private final BackoffBuilder retryBackoff;

    @Generated
    private static <T> long $default$refreshAfterWriteMillis() {
        return DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    @Generated
    private static <T> long $default$expireAfterWriteMillis() {
        return 2L * DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    @Generated
    private static <T> BiConsumer<String, Optional<CacheGetResult<T>>> $default$asyncReloadConsumer() {
        return null;
    }

    @Generated
    private static <T> BackoffBuilder $default$retryBackoff() {
        return DEFAULT_RETRY_BACKOFF_BUILDER;
    }

    @Generated
    MetadataCacheConfig(long refreshAfterWriteMillis, long expireAfterWriteMillis, BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer, BackoffBuilder retryBackoff) {
        this.refreshAfterWriteMillis = refreshAfterWriteMillis;
        this.expireAfterWriteMillis = expireAfterWriteMillis;
        this.asyncReloadConsumer = asyncReloadConsumer;
        this.retryBackoff = retryBackoff;
    }

    @Generated
    public static <T> MetadataCacheConfigBuilder<T> builder() {
        return new MetadataCacheConfigBuilder();
    }

    @Generated
    public long getRefreshAfterWriteMillis() {
        return this.refreshAfterWriteMillis;
    }

    @Generated
    public long getExpireAfterWriteMillis() {
        return this.expireAfterWriteMillis;
    }

    @Generated
    public BiConsumer<String, Optional<CacheGetResult<T>>> getAsyncReloadConsumer() {
        return this.asyncReloadConsumer;
    }

    @Generated
    public BackoffBuilder getRetryBackoff() {
        return this.retryBackoff;
    }

    @Generated
    public String toString() {
        return "MetadataCacheConfig(refreshAfterWriteMillis=" + this.getRefreshAfterWriteMillis() + ", expireAfterWriteMillis=" + this.getExpireAfterWriteMillis() + ", asyncReloadConsumer=" + this.getAsyncReloadConsumer() + ", retryBackoff=" + this.getRetryBackoff() + ")";
    }

    @Generated
    public static class MetadataCacheConfigBuilder<T> {
        @Generated
        private boolean refreshAfterWriteMillis$set;
        @Generated
        private long refreshAfterWriteMillis$value;
        @Generated
        private boolean expireAfterWriteMillis$set;
        @Generated
        private long expireAfterWriteMillis$value;
        @Generated
        private boolean asyncReloadConsumer$set;
        @Generated
        private BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer$value;
        @Generated
        private boolean retryBackoff$set;
        @Generated
        private BackoffBuilder retryBackoff$value;

        @Generated
        MetadataCacheConfigBuilder() {
        }

        @Generated
        public MetadataCacheConfigBuilder<T> refreshAfterWriteMillis(long refreshAfterWriteMillis) {
            this.refreshAfterWriteMillis$value = refreshAfterWriteMillis;
            this.refreshAfterWriteMillis$set = true;
            return this;
        }

        @Generated
        public MetadataCacheConfigBuilder<T> expireAfterWriteMillis(long expireAfterWriteMillis) {
            this.expireAfterWriteMillis$value = expireAfterWriteMillis;
            this.expireAfterWriteMillis$set = true;
            return this;
        }

        @Generated
        public MetadataCacheConfigBuilder<T> asyncReloadConsumer(BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer) {
            this.asyncReloadConsumer$value = asyncReloadConsumer;
            this.asyncReloadConsumer$set = true;
            return this;
        }

        @Generated
        public MetadataCacheConfigBuilder<T> retryBackoff(BackoffBuilder retryBackoff) {
            this.retryBackoff$value = retryBackoff;
            this.retryBackoff$set = true;
            return this;
        }

        @Generated
        public MetadataCacheConfig<T> build() {
            long refreshAfterWriteMillis$value = this.refreshAfterWriteMillis$value;
            if (!this.refreshAfterWriteMillis$set) {
                refreshAfterWriteMillis$value = MetadataCacheConfig.$default$refreshAfterWriteMillis();
            }
            long expireAfterWriteMillis$value = this.expireAfterWriteMillis$value;
            if (!this.expireAfterWriteMillis$set) {
                expireAfterWriteMillis$value = MetadataCacheConfig.$default$expireAfterWriteMillis();
            }
            BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer$value = this.asyncReloadConsumer$value;
            if (!this.asyncReloadConsumer$set) {
                asyncReloadConsumer$value = MetadataCacheConfig.$default$asyncReloadConsumer();
            }
            BackoffBuilder retryBackoff$value = this.retryBackoff$value;
            if (!this.retryBackoff$set) {
                retryBackoff$value = MetadataCacheConfig.$default$retryBackoff();
            }
            return new MetadataCacheConfig<T>(refreshAfterWriteMillis$value, expireAfterWriteMillis$value, asyncReloadConsumer$value, retryBackoff$value);
        }

        @Generated
        public String toString() {
            return "MetadataCacheConfig.MetadataCacheConfigBuilder(refreshAfterWriteMillis$value=" + this.refreshAfterWriteMillis$value + ", expireAfterWriteMillis$value=" + this.expireAfterWriteMillis$value + ", asyncReloadConsumer$value=" + this.asyncReloadConsumer$value + ", retryBackoff$value=" + this.retryBackoff$value + ")";
        }
    }
}

