/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.common.util.MathUtils;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;

class GetBookieInfoCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.GetBookieInfoCallback cb;

    public GetBookieInfoCompletion(CompletionKey key, BookkeeperInternalCallbacks.GetBookieInfoCallback origCallback, Object origCtx, PerChannelBookieClient perChannelBookieClient) {
        super("GetBookieInfo", origCtx, 0L, 0L, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.getBookieInfoOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.getBookieInfoTimeoutOpLogger;
        this.cb = (rc, bInfo, ctx) -> {
            this.logOpResult(rc);
            origCallback.getBookieInfoComplete(rc, bInfo, origCtx);
            key.release();
        };
    }

    @Override
    boolean maybeTimeout() {
        if (MathUtils.elapsedNanos((long)this.startTime) >= this.perChannelBookieClient.getBookieInfoTimeoutNanos) {
            this.timeout();
            return true;
        }
        return false;
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.cb.getBookieInfoComplete(rc, new BookieInfoReader.BookieInfo(), this.ctx));
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        BookkeeperProtocol.GetBookieInfoResponse getBookieInfoResponse = response.getGetBookieInfoResponse();
        BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? getBookieInfoResponse.getStatus() : response.getStatus();
        long freeDiskSpace = getBookieInfoResponse.getFreeDiskSpace();
        long totalDiskSpace = getBookieInfoResponse.getTotalDiskCapacity();
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, "freeDisk", freeDiskSpace, "totalDisk", totalDiskSpace);
        }
        int rc = this.convertStatus(status, -1);
        this.cb.getBookieInfoComplete(rc, new BookieInfoReader.BookieInfo(totalDiskSpace, freeDiskSpace), this.ctx);
    }
}

