/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.internal.InnerClassFactory;
import org.apache.pulsar.internal.ShellCommandsProvider;
import org.apache.pulsar.shell.PulsarShell;
import org.apache.pulsar.shell.config.ConfigStore;
import picocli.CommandLine;

@CommandLine.Command(description={"Manage Pulsar shell configurations."})
public class ConfigShell
implements ShellCommandsProvider {
    private static final String LOCAL_FILES_BASE_DIR = System.getProperty("pulsar.shell.working.dir");
    private final PulsarShell pulsarShell;
    private final ConfigStore configStore;
    private final ObjectMapper writer = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final CommandLine commander = new CommandLine((Object)this, (CommandLine.IFactory)new InnerClassFactory(this));
    private String currentConfig;

    static File resolveLocalFile(String input) {
        return ConfigShell.resolveLocalFile(input, LOCAL_FILES_BASE_DIR);
    }

    static File resolveLocalFile(String input, String baseDir) {
        File file = new File(input);
        if (!file.isAbsolute() && baseDir != null) {
            return new File(baseDir, input);
        }
        return file;
    }

    public ConfigShell(PulsarShell pulsarShell, String currentConfig) {
        this.configStore = pulsarShell.getConfigStore();
        this.pulsarShell = pulsarShell;
        this.currentConfig = currentConfig;
        this.commander.addSubcommand("list", (Object)new CmdConfigList());
        this.commander.addSubcommand("create", (Object)new CmdConfigCreate());
        this.commander.addSubcommand("clone", (Object)new CmdConfigClone());
        this.commander.addSubcommand("update", (Object)new CmdConfigUpdate());
        this.commander.addSubcommand("delete", (Object)new CmdConfigDelete());
        this.commander.addSubcommand("use", (Object)new CmdConfigUse());
        this.commander.addSubcommand("view", (Object)new CmdConfigView());
        this.commander.addSubcommand("set-property", (Object)new CmdConfigSetProperty());
        this.commander.addSubcommand("get-property", (Object)new CmdConfigGetProperty());
    }

    @Override
    public String getName() {
        return "config";
    }

    @Override
    public String getServiceUrl() {
        return null;
    }

    @Override
    public String getAdminUrl() {
        return null;
    }

    @Override
    public CommandLine getCommander() {
        return this.commander;
    }

    private void reloadIfCurrent(ConfigStore.ConfigEntry entry) throws Exception {
        if (this.currentConfig.equals(entry.getName())) {
            Properties properties = new Properties();
            properties.load(new StringReader(entry.getValue()));
            this.pulsarShell.reload(properties);
        }
    }

    <T> void print(List<T> items) {
        for (T item : items) {
            this.print(item);
        }
    }

    <T> void print(T item) {
        try {
            if (item instanceof String) {
                this.commander.getOut().println((String)item);
            } else {
                this.commander.getOut().println(this.writer.writeValueAsString(item));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public String getCurrentConfig() {
        return this.currentConfig;
    }

    @CommandLine.Command(description={"List configurations"})
    private class CmdConfigList
    implements RunnableWithResult {
        private CmdConfigList() {
        }

        @Override
        public boolean run() {
            ConfigShell.this.print(ConfigShell.this.configStore.listConfigs().stream().map(e -> this.formatEntry((ConfigStore.ConfigEntry)e)).collect(Collectors.toList()));
            return true;
        }

        private String formatEntry(ConfigStore.ConfigEntry entry) {
            String name = entry.getName();
            if (name.equals(ConfigShell.this.currentConfig)) {
                return name + " (*)";
            }
            return name;
        }
    }

    @CommandLine.Command(name="create", description={"Create a new configuration."})
    private class CmdConfigCreate
    extends CmdConfigPut {
        @CommandLine.Parameters(description={"Configuration name"}, arity="1")
        protected String name;

        private CmdConfigCreate() {
        }

        @Override
        boolean verifyCondition() {
            boolean exists;
            boolean bl = exists = ConfigShell.this.configStore.getConfig(this.name) != null;
            if (exists) {
                ConfigShell.this.print("Config '" + this.name + "' already exists.");
                return false;
            }
            return true;
        }

        @Override
        String name() {
            return this.name;
        }
    }

    @CommandLine.Command
    private class CmdConfigClone
    implements RunnableWithResult {
        @CommandLine.Parameters(description={"Configuration to clone"}, arity="1", completionCandidates=ConfigNameCompletionCandidates.class)
        protected String cloneFrom;
        @CommandLine.Option(names={"--name"}, description={"Name of the new config"}, required=true)
        protected String newName;

        private CmdConfigClone() {
        }

        @Override
        public boolean run() {
            if ("default".equals(this.newName) || ConfigShell.this.configStore.getConfig(this.newName) != null) {
                ConfigShell.this.print("'" + this.newName + "' already exists.");
                return false;
            }
            ConfigStore.ConfigEntry config = ConfigShell.this.configStore.getConfig(this.cloneFrom);
            if (config == null) {
                ConfigShell.this.print("Config '" + config + "' does not exist.");
                return false;
            }
            ConfigStore.ConfigEntry entry = new ConfigStore.ConfigEntry(this.newName, config.getValue());
            ConfigShell.this.configStore.putConfig(entry);
            ConfigShell.this.reloadIfCurrent(entry);
            return true;
        }
    }

    @CommandLine.Command(description={"Update an existing configuration."})
    private class CmdConfigUpdate
    extends CmdConfigPut {
        @CommandLine.Parameters(description={"Name of the config"}, arity="1", completionCandidates=ConfigNameCompletionCandidates.class)
        protected String name;

        private CmdConfigUpdate() {
        }

        @Override
        boolean verifyCondition() {
            boolean exists;
            if ("default".equals(this.name)) {
                ConfigShell.this.print("'" + this.name + "' can't be updated.");
                return false;
            }
            boolean bl = exists = ConfigShell.this.configStore.getConfig(this.name) != null;
            if (!exists) {
                ConfigShell.this.print("Config '" + this.name + "' does not exist.");
                return false;
            }
            return true;
        }

        @Override
        String name() {
            return this.name;
        }
    }

    @CommandLine.Command(description={"Delete a configuration"})
    private class CmdConfigDelete
    implements RunnableWithResult {
        @CommandLine.Parameters(description={"Name of the config"}, arity="1", completionCandidates=ConfigNameCompletionCandidates.class)
        private String name;

        private CmdConfigDelete() {
        }

        @Override
        public boolean run() {
            if ("default".equals(this.name)) {
                ConfigShell.this.print("'" + this.name + "' can't be deleted.");
                return false;
            }
            if (ConfigShell.this.currentConfig != null && ConfigShell.this.currentConfig.equals(this.name)) {
                ConfigShell.this.print("'" + this.name + "' is currently used and it can't be deleted.");
                return false;
            }
            ConfigShell.this.configStore.deleteConfig(this.name);
            return true;
        }
    }

    @CommandLine.Command(description={"Use the configuration for next commands"})
    private class CmdConfigUse
    implements RunnableWithResult {
        @CommandLine.Parameters(description={"Name of the config"}, arity="1", completionCandidates=ConfigNameCompletionCandidates.class)
        private String name;

        private CmdConfigUse() {
        }

        @Override
        public boolean run() {
            ConfigStore.ConfigEntry config = ConfigShell.this.configStore.getConfig(this.name);
            if (config == null) {
                ConfigShell.this.print("Config " + this.name + " not found");
                return false;
            }
            String value = config.getValue();
            ConfigShell.this.currentConfig = this.name;
            Properties properties = new Properties();
            properties.load(new StringReader(value));
            ConfigShell.this.pulsarShell.reload(properties);
            ConfigShell.this.configStore.setLastUsed(this.name);
            return true;
        }
    }

    @CommandLine.Command(description={"View configuration"})
    private class CmdConfigView
    implements RunnableWithResult {
        @CommandLine.Parameters(description={"Name of the config"}, arity="1", completionCandidates=ConfigNameCompletionCandidates.class)
        private String name;

        private CmdConfigView() {
        }

        @Override
        public boolean run() {
            ConfigStore.ConfigEntry config = ConfigShell.this.configStore.getConfig(this.name);
            if (config == null) {
                ConfigShell.this.print("Config " + this.name + " not found");
                return false;
            }
            ConfigShell.this.print(config.getValue());
            return true;
        }
    }

    @CommandLine.Command(description={"Set a configuration property by name"})
    private class CmdConfigSetProperty
    implements RunnableWithResult {
        @CommandLine.Parameters(description={"Name of the config"}, arity="1", completionCandidates=ConfigNameCompletionCandidates.class)
        private String name;
        @CommandLine.Option(names={"-p", "--property"}, required=true, description={"Name of the property to update"})
        protected String propertyName;
        @CommandLine.Option(names={"-v", "--value"}, description={"New value for the property"})
        protected String propertyValue;

        private CmdConfigSetProperty() {
        }

        @Override
        public boolean run() {
            if (StringUtils.isBlank((CharSequence)this.propertyName)) {
                ConfigShell.this.print("-p parameter is required");
                return false;
            }
            if (this.propertyValue == null) {
                ConfigShell.this.print("-v parameter is required. You can pass an empty value to empty the property. (-v= )");
                return false;
            }
            ConfigStore.ConfigEntry config = ConfigShell.this.configStore.getConfig(this.name);
            if (config == null) {
                ConfigShell.this.print("Config " + this.name + " not found");
                return false;
            }
            ConfigStore.setProperty(config, this.propertyName, this.propertyValue);
            ConfigShell.this.print("Property " + this.propertyName + " set for config " + this.name);
            ConfigShell.this.configStore.putConfig(config);
            ConfigShell.this.reloadIfCurrent(config);
            return true;
        }
    }

    @CommandLine.Command(description={"Get a configuration property by name"})
    private class CmdConfigGetProperty
    implements RunnableWithResult {
        @CommandLine.Parameters(description={"Name of the config"}, arity="1", completionCandidates=ConfigNameCompletionCandidates.class)
        private String name;
        @CommandLine.Option(names={"-p", "--property"}, required=true, description={"Name of the property"})
        protected String propertyName;

        private CmdConfigGetProperty() {
        }

        @Override
        public boolean run() {
            if (StringUtils.isBlank((CharSequence)this.propertyName)) {
                ConfigShell.this.print("-p parameter is required");
                return false;
            }
            ConfigStore.ConfigEntry config = ConfigShell.this.configStore.getConfig(this.name);
            if (config == null) {
                ConfigShell.this.print("Config " + this.name + " not found");
                return false;
            }
            String value = ConfigStore.getProperty(config, this.propertyName);
            if (!StringUtils.isBlank((CharSequence)value)) {
                ConfigShell.this.print(value);
            }
            return true;
        }
    }

    private abstract class CmdConfigPut
    implements RunnableWithResult {
        @CommandLine.Option(names={"--url"}, description={"URL of the config"})
        protected String url;
        @CommandLine.Option(names={"--file"}, description={"File path of the config"}, completionCandidates=ConfigFileCompletionCandidates.class)
        protected String file;
        @CommandLine.Option(names={"--value"}, description={"Inline value of the config"})
        protected String inlineValue;

        private CmdConfigPut() {
        }

        @Override
        public boolean run() {
            String value;
            if (!this.verifyCondition()) {
                return false;
            }
            String name = this.name();
            if (this.inlineValue != null) {
                if (this.inlineValue.startsWith("base64:")) {
                    byte[] bytes = Base64.getDecoder().decode(this.inlineValue.substring("base64:".length()));
                    value = new String(bytes, StandardCharsets.UTF_8);
                } else {
                    value = this.inlineValue;
                }
            } else if (this.file != null) {
                File f = ConfigShell.resolveLocalFile(this.file);
                if (!f.exists()) {
                    ConfigShell.this.print("File " + f.getAbsolutePath() + " not found.");
                    return false;
                }
                value = new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
            } else if (this.url != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try (InputStream in = URI.create(this.url).toURL().openStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)bout);
                }
                catch (IOException | IllegalArgumentException e) {
                    ConfigShell.this.print("Failed to download configuration: " + e.getMessage());
                    return false;
                }
                value = new String(bout.toByteArray(), StandardCharsets.UTF_8);
            } else {
                ConfigShell.this.print("At least one between --file, --url or --value is required.");
                return false;
            }
            ConfigStore.ConfigEntry entry = new ConfigStore.ConfigEntry(name, value);
            ConfigShell.this.configStore.putConfig(entry);
            ConfigShell.this.reloadIfCurrent(entry);
            return true;
        }

        abstract String name();

        abstract boolean verifyCondition();
    }

    static class ConfigFileCompletionCandidates
    implements Iterable<String> {
        ConfigFileCompletionCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            String path = ConfigShell.resolveLocalFile(".").toPath().toString();
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(path);
            return strings.iterator();
        }
    }

    public class ConfigNameCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return ConfigShell.this.pulsarShell.getConfigStore().listConfigs().stream().map(ConfigStore.ConfigEntry::getName).iterator();
        }
    }

    private static interface RunnableWithResult
    extends Callable<Integer> {
        public boolean run() throws Exception;

        @Override
        default public Integer call() throws Exception {
            if (this.run()) {
                return 0;
            }
            return 1;
        }
    }
}

