/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.grpc.proxy;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import org.apache.bookkeeper.common.grpc.proxy.ChannelFinder;
import org.apache.bookkeeper.common.grpc.proxy.ProxyCall;

class ProxyServerCallHandler<ReqT, RespT>
implements ServerCallHandler<ReqT, RespT> {
    private final ChannelFinder finder;
    private final CallOptions callOptions;

    ProxyServerCallHandler(ChannelFinder finder, CallOptions callOptions) {
        this.finder = finder;
        this.callOptions = callOptions;
    }

    public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> serverCall, Metadata headers) {
        Channel channel = this.finder.findChannel(serverCall, headers);
        ClientCall clientCall = channel.newCall(serverCall.getMethodDescriptor(), this.callOptions);
        ProxyCall<ReqT, RespT> proxyCall = new ProxyCall<ReqT, RespT>(serverCall, clientCall);
        clientCall.start((ClientCall.Listener)proxyCall.getClientCallListener(), headers);
        serverCall.request(1);
        clientCall.request(1);
        return proxyCall.getServerCallListener();
    }
}

