/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.compaction.EventTimeOrderCompactor;
import org.apache.pulsar.compaction.PublishingOrderCompactor;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="compact-topic", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
public class CompactorTool {
    private static final Logger log = LoggerFactory.getLogger(CompactorTool.class);

    public static PulsarClient createClient(ServiceConfiguration brokerConfig) throws PulsarClientException {
        AdvertisedListener internalListener;
        ClientBuilder clientBuilder = PulsarClient.builder().memoryLimit(0L, SizeUnit.BYTES);
        clientBuilder.loadConf(PropertiesUtils.filterAndMapProperties((Properties)brokerConfig.getProperties(), (String)"brokerClient_"));
        if (StringUtils.isNotBlank((CharSequence)brokerConfig.getBrokerClientAuthenticationPlugin())) {
            clientBuilder.authentication(brokerConfig.getBrokerClientAuthenticationPlugin(), brokerConfig.getBrokerClientAuthenticationParameters());
        }
        if ((internalListener = ServiceConfigurationUtils.getInternalListener((ServiceConfiguration)brokerConfig, (String)"pulsar+ssl")).getBrokerServiceUrlTls() != null && brokerConfig.isBrokerClientTlsEnabled()) {
            clientBuilder.serviceUrl(internalListener.getBrokerServiceUrlTls().toString()).allowTlsInsecureConnection(brokerConfig.isTlsAllowInsecureConnection()).enableTlsHostnameVerification(brokerConfig.isTlsHostnameVerificationEnabled()).sslFactoryPlugin(brokerConfig.getBrokerClientSslFactoryPlugin()).sslFactoryPluginParams(brokerConfig.getBrokerClientSslFactoryPluginParams());
            if (brokerConfig.isBrokerClientTlsEnabledWithKeyStore()) {
                clientBuilder.useKeyStoreTls(true).tlsKeyStoreType(brokerConfig.getBrokerClientTlsKeyStoreType()).tlsKeyStorePath(brokerConfig.getBrokerClientTlsKeyStore()).tlsKeyStorePassword(brokerConfig.getBrokerClientTlsKeyStorePassword()).tlsTrustStoreType(brokerConfig.getBrokerClientTlsTrustStoreType()).tlsTrustStorePath(brokerConfig.getBrokerClientTlsTrustStore()).tlsTrustStorePassword(brokerConfig.getBrokerClientTlsTrustStorePassword());
            } else {
                clientBuilder.tlsTrustCertsFilePath(brokerConfig.getBrokerClientTrustCertsFilePath()).tlsKeyFilePath(brokerConfig.getBrokerClientKeyFilePath()).tlsCertificateFilePath(brokerConfig.getBrokerClientCertificateFilePath());
            }
        } else {
            internalListener = ServiceConfigurationUtils.getInternalListener((ServiceConfiguration)brokerConfig, (String)"pulsar");
            clientBuilder.serviceUrl(internalListener.getBrokerServiceUrl().toString());
        }
        return clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        CommandLine commander = new CommandLine((Object)arguments);
        commander.setCommandName("PulsarTopicCompactor");
        commander.parseArgs(args);
        if (arguments.help) {
            commander.usage(commander.getOut());
            System.exit(0);
        }
        if (arguments.generateDocs) {
            CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
            cmd.addCommand("compact-topic", (Object)arguments);
            cmd.run(null);
            System.exit(0);
        }
        if (StringUtils.isBlank((CharSequence)arguments.brokerConfigFile)) {
            commander.usage(commander.getOut());
            throw new IllegalArgumentException("Need to specify a configuration file for broker");
        }
        String filepath = Path.of(arguments.brokerConfigFile, new String[0]).toAbsolutePath().normalize().toString();
        log.info(String.format("read configuration file %s", filepath));
        ServiceConfiguration brokerConfig = (ServiceConfiguration)PulsarConfigurationLoader.create((String)filepath, ServiceConfiguration.class);
        if (StringUtils.isBlank((CharSequence)brokerConfig.getMetadataStoreUrl())) {
            String message = String.format("Need to specify `metadataStoreUrl` or `zookeeperServers` in configuration file\nor specify configuration file path from command line.\nnow configuration file path is=[%s]\n", filepath);
            throw new IllegalArgumentException(message);
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("compaction-%d").setDaemon(true).build());
        try {
            MetadataStoreExtended store = MetadataStoreExtended.create((String)brokerConfig.getMetadataStoreUrl(), (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis((int)brokerConfig.getMetadataStoreSessionTimeoutMillis()).metadataStoreName("metadata-store").build());
            try {
                BookKeeperClientFactoryImpl bkClientFactory = new BookKeeperClientFactoryImpl();
                try {
                    EventLoopGroup eventLoopGroup = EventLoopUtil.newEventLoopGroup((int)1, (boolean)false, (ThreadFactory)new DefaultThreadFactory("compactor-io"));
                    try {
                        BookKeeper bk = bkClientFactory.create(brokerConfig, store, eventLoopGroup, Optional.empty(), null).get();
                        try {
                            PulsarClient pulsar = CompactorTool.createClient(brokerConfig);
                            try {
                                Compactor compactor = null;
                                switch (arguments.compactorType) {
                                    case PUBLISHING: {
                                        compactor = new PublishingOrderCompactor(brokerConfig, pulsar, bk, scheduler);
                                        break;
                                    }
                                    case EVENT_TIME: {
                                        compactor = new EventTimeOrderCompactor(brokerConfig, pulsar, bk, scheduler);
                                    }
                                }
                                long ledgerId = compactor.compact(arguments.topic).get();
                                log.info("Compaction of topic {} complete. Compacted to ledger {}", (Object)arguments.topic, (Object)ledgerId);
                            }
                            finally {
                                if (Collections.singletonList(pulsar).get(0) != null) {
                                    pulsar.close();
                                }
                            }
                        }
                        finally {
                            if (Collections.singletonList(bk).get(0) != null) {
                                bk.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(eventLoopGroup).get(0) != null) {
                            eventLoopGroup.shutdownGracefully();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bkClientFactory).get(0) != null) {
                        bkClientFactory.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(store).get(0) != null) {
                    store.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(scheduler).get(0) != null) {
                scheduler.shutdownNow();
            }
        }
    }

    private static class Arguments {
        @CommandLine.Option(names={"-c", "--broker-conf"}, description={"Configuration file for Broker"})
        private String brokerConfigFile = "conf/broker.conf";
        @CommandLine.Option(names={"-t", "--topic"}, description={"Topic to compact"}, required=true)
        private String topic;
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;
        @CommandLine.Option(names={"-ct", "--compactor-type"}, description={"Choose compactor type, valid types are [PUBLISHING, EVENT_TIME]"})
        private CompactorType compactorType = CompactorType.PUBLISHING;

        private Arguments() {
        }

        public static enum CompactorType {
            PUBLISHING,
            EVENT_TIME;

        }
    }
}

