/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.compaction.CompactedTopicImpl;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.compaction.TopicCompactionService;
import org.jspecify.annotations.NonNull;

public class PulsarTopicCompactionService
implements TopicCompactionService {
    private final String topic;
    private final CompactedTopicImpl compactedTopic;
    private final Supplier<Compactor> compactorSupplier;

    public PulsarTopicCompactionService(String topic, BookKeeper bookKeeper, Supplier<Compactor> compactorSupplier) {
        this.topic = topic;
        this.compactedTopic = new CompactedTopicImpl(bookKeeper);
        this.compactorSupplier = compactorSupplier;
    }

    @Override
    public CompletableFuture<Void> compact() {
        Compactor compactor;
        try {
            compactor = this.compactorSupplier.get();
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
        return compactor.compact(this.topic).thenApply(x -> null);
    }

    @Override
    public CompletableFuture<List<Entry>> readCompactedEntries(@NonNull Position startPosition, int numberOfEntriesToRead) {
        Objects.requireNonNull(startPosition);
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        CompletableFuture<List<Entry>> resultFuture = new CompletableFuture<List<Entry>>();
        ((CompletableFuture)Objects.requireNonNull(this.compactedTopic.getCompactedTopicContextFuture()).thenCompose(context -> CompactedTopicImpl.findStartPoint(startPosition, context.ledger.getLastAddConfirmed(), context.cache).thenCompose(startPoint -> {
            if (startPoint == -4276948923L || startPoint == -4276948922L) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            long endPoint = Math.min(context.ledger.getLastAddConfirmed(), startPoint + (long)(numberOfEntriesToRead - 1));
            return CompactedTopicImpl.readEntries(context.ledger, startPoint, endPoint);
        }))).whenComplete((result, ex) -> {
            if (ex == null) {
                resultFuture.complete((List<Entry>)result);
            } else if ((ex = FutureUtil.unwrapCompletionException((Throwable)ex)) instanceof NoSuchElementException) {
                resultFuture.complete(Collections.emptyList());
            } else {
                resultFuture.completeExceptionally((Throwable)ex);
            }
        });
        return resultFuture;
    }

    @Override
    public CompletableFuture<Position> getLastCompactedPosition() {
        return CompletableFuture.completedFuture(this.compactedTopic.getCompactionHorizon().orElse(null));
    }

    @Override
    public CompletableFuture<Position> findEntryByPublishTime(long publishTime) {
        Predicate<Entry> predicate = entry -> Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer()).getPublishTime() >= publishTime;
        return this.compactedTopic.findFirstMatchEntry(predicate).thenApply(entry -> {
            try {
                Position position = PositionFactory.create((long)entry.getLedgerId(), (long)entry.getEntryId());
                return position;
            }
            finally {
                entry.release();
            }
        });
    }

    @Override
    public CompletableFuture<TopicCompactionService.MessagePosition> getLastMessagePosition() {
        return this.compactedTopic.readLastEntryOfCompactedLedger().thenApply(entry -> {
            if (entry == null) {
                return TopicCompactionService.MessagePosition.EARLIEST;
            }
            try {
                TopicCompactionService.MessagePosition messagePosition;
                ByteBuf uncompressedPayload;
                ByteBuf payload = entry.getDataBuffer();
                MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
                int batchSize = metadata.getNumMessagesInBatch();
                long publishTime = metadata.getPublishTime();
                if (batchSize <= 1) {
                    TopicCompactionService.MessagePosition messagePosition2 = new TopicCompactionService.MessagePosition(entry.getLedgerId(), entry.getEntryId(), -1, publishTime);
                    return messagePosition2;
                }
                int compactedBatchIndexesCount = metadata.getCompactedBatchIndexesCount();
                if (compactedBatchIndexesCount > 0) {
                    int batchIndex = metadata.getCompactedBatchIndexeAt(compactedBatchIndexesCount - 1);
                    TopicCompactionService.MessagePosition messagePosition3 = new TopicCompactionService.MessagePosition(entry.getLedgerId(), entry.getEntryId(), batchIndex, publishTime);
                    return messagePosition3;
                }
                if (metadata.getEncryptionKeysCount() > 0) {
                    TopicCompactionService.MessagePosition batchIndex = new TopicCompactionService.MessagePosition(entry.getLedgerId(), entry.getEntryId(), batchSize - 1, publishTime);
                    return batchIndex;
                }
                if (metadata.hasCompression()) {
                    CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((CompressionType)metadata.getCompression());
                    int uncompressedSize = metadata.getUncompressedSize();
                    uncompressedPayload = codec.decode(payload, uncompressedSize);
                } else {
                    uncompressedPayload = payload.retain();
                }
                try {
                    SingleMessageMetadata singleMessageMetadata = new SingleMessageMetadata();
                    int batchIndex = -1;
                    for (int i = 0; i < batchSize; ++i) {
                        ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)payload, (SingleMessageMetadata)singleMessageMetadata, (int)i, (int)batchSize);
                        singleMessagePayload.release();
                        if (singleMessageMetadata.isCompactedOut()) continue;
                        batchIndex = i;
                    }
                    if (batchIndex < 0) {
                        throw new IllegalStateException("No valid message in entry " + entry.getPosition());
                    }
                    messagePosition = new TopicCompactionService.MessagePosition(entry.getLedgerId(), entry.getEntryId(), batchIndex, publishTime);
                }
                catch (Throwable throwable) {
                    try {
                        uncompressedPayload.release();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }
                uncompressedPayload.release();
                return messagePosition;
            }
            finally {
                entry.release();
            }
        });
    }

    public CompactedTopicImpl getCompactedTopic() {
        return this.compactedTopic;
    }

    @Override
    public void close() throws IOException {
    }
}

