/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.execute.GenericPrivilegeInfo;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.shared.common.error.StandardException;

class PrivilegeNode
extends QueryTreeNode {
    public static final int TABLE_PRIVILEGES = 0;
    public static final int ROUTINE_PRIVILEGES = 1;
    public static final int SEQUENCE_PRIVILEGES = 2;
    public static final int UDT_PRIVILEGES = 3;
    public static final int AGGREGATE_PRIVILEGES = 4;
    private int objectType;
    private TableName objectName;
    private TablePrivilegesNode specificPrivileges;
    private RoutineDesignator routineDesignator;
    private String privilege;
    private boolean restrict;
    private Provider dependencyProvider;

    PrivilegeNode(int n, Object object, TablePrivilegesNode tablePrivilegesNode, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.objectType = n;
        switch (this.objectType) {
            case 0: {
                this.objectName = (TableName)object;
                this.specificPrivileges = tablePrivilegesNode;
                break;
            }
            case 1: {
                this.routineDesignator = (RoutineDesignator)object;
                this.objectName = this.routineDesignator.name;
                break;
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
    }

    PrivilegeNode(int n, TableName tableName, String string, boolean bl, ContextManager contextManager) {
        super(contextManager);
        this.objectType = n;
        this.objectName = tableName;
        this.privilege = string;
        this.restrict = bl;
    }

    public QueryTreeNode bind(HashMap<Provider, Provider> hashMap, List<String> list, boolean bl) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.objectName.getSchemaName(), true);
        this.objectName.setSchemaName(schemaDescriptor.getSchemaName());
        if (list.contains(schemaDescriptor.getAuthorizationId())) {
            throw StandardException.newException((String)"42509", (Object[])new Object[]{this.objectName.getFullTableName()});
        }
        switch (this.objectType) {
            case 0: {
                if (schemaDescriptor.isSystemSchema()) {
                    throw StandardException.newException((String)"42509", (Object[])new Object[]{this.objectName.getFullTableName()});
                }
                TableDescriptor tableDescriptor = this.getTableDescriptor(this.objectName.getTableName(), schemaDescriptor);
                if (tableDescriptor == null) {
                    throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.objectName});
                }
                if (PrivilegeNode.isSessionSchema(schemaDescriptor.getSchemaName())) {
                    throw StandardException.newException((String)"XCL51.S", (Object[])new Object[0]);
                }
                if (tableDescriptor.getTableType() != 0 && tableDescriptor.getTableType() != 2) {
                    throw StandardException.newException((String)"42509", (Object[])new Object[]{this.objectName.getFullTableName()});
                }
                this.specificPrivileges.bind(tableDescriptor, bl);
                this.dependencyProvider = tableDescriptor;
                break;
            }
            case 1: {
                if (!schemaDescriptor.isSchemaWithGrantableRoutines()) {
                    throw StandardException.newException((String)"42509", (Object[])new Object[]{this.objectName.getFullTableName()});
                }
                AliasDescriptor aliasDescriptor = null;
                List<AliasDescriptor> list2 = this.getDataDictionary().getRoutineList(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), this.routineDesignator.isFunction ? (char)'F' : 'P');
                if (this.routineDesignator.paramTypeList == null) {
                    if (list2.size() > 1) {
                        throw StandardException.newException((String)(this.routineDesignator.isFunction ? "42X46" : "42X47"), (Object[])new Object[]{this.objectName.getFullTableName()});
                    }
                    if (list2.size() != 1) {
                        if (this.routineDesignator.isFunction) {
                            throw StandardException.newException((String)"42Y03.S.2", (Object[])new Object[]{this.objectName.getFullTableName()});
                        }
                        throw StandardException.newException((String)"42Y03.S.1", (Object[])new Object[]{this.objectName.getFullTableName()});
                    }
                    aliasDescriptor = list2.get(0);
                } else {
                    boolean bl2 = false;
                    block7: for (int i = list2.size() - 1; !bl2 && i >= 0; --i) {
                        aliasDescriptor = list2.get(i);
                        RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                        int n = routineAliasInfo.getParameterCount();
                        if (n != this.routineDesignator.paramTypeList.size()) continue;
                        TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
                        bl2 = true;
                        for (int j = 0; j < n; ++j) {
                            if (typeDescriptorArray[j].equals(this.routineDesignator.paramTypeList.get(j))) continue;
                            bl2 = false;
                            continue block7;
                        }
                    }
                    if (!bl2) {
                        StringBuilder stringBuilder = new StringBuilder(this.objectName.getFullTableName());
                        stringBuilder.append("(");
                        for (int i = 0; i < this.routineDesignator.paramTypeList.size(); ++i) {
                            if (i > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(this.routineDesignator.paramTypeList.get(i).toString());
                        }
                        throw StandardException.newException((String)"42Y03.S.0", (Object[])new Object[]{stringBuilder.toString()});
                    }
                }
                this.routineDesignator.setAliasDescriptor(aliasDescriptor);
                this.dependencyProvider = aliasDescriptor;
                break;
            }
            case 4: {
                this.dependencyProvider = this.getDataDictionary().getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), 'G');
                if (this.dependencyProvider != null) break;
                throw StandardException.newException((String)"42X94", (Object[])new Object[]{"DERBY AGGREGATE", this.objectName.getFullTableName()});
            }
            case 2: {
                this.dependencyProvider = this.getDataDictionary().getSequenceDescriptor(schemaDescriptor, this.objectName.getTableName());
                if (this.dependencyProvider != null) break;
                throw StandardException.newException((String)"42X94", (Object[])new Object[]{"SEQUENCE", this.objectName.getFullTableName()});
            }
            case 3: {
                this.dependencyProvider = this.getDataDictionary().getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), 'A');
                if (this.dependencyProvider != null) break;
                throw StandardException.newException((String)"42X94", (Object[])new Object[]{"TYPE", this.objectName.getFullTableName()});
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
        if (this.dependencyProvider != null && hashMap.get(this.dependencyProvider) == null) {
            this.getCompilerContext().createDependency(this.dependencyProvider);
            hashMap.put(this.dependencyProvider, this.dependencyProvider);
        }
        return this;
    }

    PrivilegeInfo makePrivilegeInfo() throws StandardException {
        switch (this.objectType) {
            case 0: {
                return this.specificPrivileges.makePrivilegeInfo();
            }
            case 1: {
                return this.routineDesignator.makePrivilegeInfo();
            }
            case 2: 
            case 3: 
            case 4: {
                return new GenericPrivilegeInfo((PrivilegedSQLObject)this.dependencyProvider, this.privilege, this.restrict);
            }
        }
        throw this.unimplementedFeature();
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException((String)"XSCB3.S", (Object[])new Object[0]);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.objectName != null) {
            this.objectName = (TableName)this.objectName.accept(visitor);
        }
    }
}

