/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.List;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryTransaction;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

abstract class QueueSizeLimitRespectingTransaction
extends QueueEntryTransaction {
    private final Queue _destinationQueue;
    private long _pendingQueueDepthBytes;
    private long _pendingQueueDepthMessages;

    QueueSizeLimitRespectingTransaction(Queue sourceQueue, List<Long> messageIds, Queue destinationQueue, MessageFilter filter, int limit) {
        super(sourceQueue, messageIds, filter, limit);
        this._destinationQueue = destinationQueue;
    }

    @Override
    protected boolean updateEntry(QueueEntry entry, QueueManagingVirtualHost.Transaction txn) {
        ServerMessage message = entry.getMessage();
        ++this._pendingQueueDepthMessages;
        this._pendingQueueDepthBytes += message == null ? 0L : message.getSizeIncludingHeader();
        boolean underfull = this.isUnderfull();
        if (message != null && !message.isReferenced(this._destinationQueue) && underfull) {
            this.performOperation(entry, txn, this._destinationQueue);
        }
        return !underfull;
    }

    abstract void performOperation(QueueEntry var1, QueueManagingVirtualHost.Transaction var2, Queue var3);

    private boolean isUnderfull() {
        return this._destinationQueue.getOverflowPolicy() == OverflowPolicy.NONE || (this._destinationQueue.getMaximumQueueDepthBytes() < 0L || this._destinationQueue.getQueueDepthBytes() + this._pendingQueueDepthBytes <= this._destinationQueue.getMaximumQueueDepthBytes()) && (this._destinationQueue.getMaximumQueueDepthMessages() < 0L || (long)this._destinationQueue.getQueueDepthMessages() + this._pendingQueueDepthMessages <= this._destinationQueue.getMaximumQueueDepthMessages());
    }
}

