/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class TinyHashSet<T>
implements Iterable<T> {
    private Set<T> set;
    private T elem1;
    private T elem2;

    public TinyHashSet() {
    }

    public TinyHashSet(T o) {
        this.elem1 = o;
    }

    public int size() {
        if (this.elem1 != null && this.elem2 != null) {
            return 2;
        }
        if (this.elem1 != null || this.elem2 != null) {
            return 1;
        }
        if (this.set != null) {
            return this.set.size();
        }
        return 0;
    }

    public boolean contains(T o) {
        EnvironmentFailureException.assertState(o != null);
        EnvironmentFailureException.assertState(this.elem1 == null && this.elem2 == null || this.set == null);
        if (this.set != null) {
            return this.set.contains(o);
        }
        if (this.elem1 != null && (this.elem1 == o || this.elem1.equals(o))) {
            return true;
        }
        return this.elem2 != null && (this.elem2 == o || this.elem2.equals(o));
    }

    public boolean remove(T o) {
        EnvironmentFailureException.assertState(o != null);
        EnvironmentFailureException.assertState(this.elem1 == null && this.elem2 == null || this.set == null);
        if (this.set != null) {
            return this.set.remove(o);
        }
        if (this.elem1 != null && (this.elem1 == o || this.elem1.equals(o))) {
            this.elem1 = null;
            return true;
        }
        if (this.elem2 != null && (this.elem2 == o || this.elem2.equals(o))) {
            this.elem2 = null;
            return true;
        }
        return false;
    }

    public boolean add(T o) {
        EnvironmentFailureException.assertState(o != null);
        EnvironmentFailureException.assertState(this.elem1 == null && this.elem2 == null || this.set == null);
        if (this.set != null) {
            return this.set.add(o);
        }
        if (this.elem1 != null && (this.elem1 == o || this.elem1.equals(o))) {
            return false;
        }
        if (this.elem2 != null && (this.elem2 == o || this.elem2.equals(o))) {
            return false;
        }
        if (this.elem1 == null) {
            this.elem1 = o;
            return true;
        }
        if (this.elem2 == null) {
            this.elem2 = o;
            return true;
        }
        this.set = new HashSet<T>(5);
        this.set.add(this.elem1);
        this.set.add(this.elem2);
        this.elem1 = null;
        this.elem2 = null;
        return this.set.add(o);
    }

    public Set<T> copy() {
        EnvironmentFailureException.assertState(this.elem1 == null && this.elem2 == null || this.set == null);
        if (this.set != null) {
            return new HashSet<T>(this.set);
        }
        HashSet<T> ret = new HashSet<T>();
        if (this.elem1 != null) {
            ret.add(this.elem1);
        }
        if (this.elem2 != null) {
            ret.add(this.elem2);
        }
        return ret;
    }

    @Override
    public Iterator<T> iterator() {
        EnvironmentFailureException.assertState(this.elem1 == null && this.elem2 == null || this.set == null);
        if (this.set != null) {
            return this.set.iterator();
        }
        return new TwoElementIterator<T>(this, this.elem1, this.elem2);
    }

    private static class TwoElementIterator<T>
    implements Iterator<T> {
        final TinyHashSet<T> parent;
        final T elem1;
        final T elem2;
        boolean returnedElem1;
        boolean returnedElem2;

        TwoElementIterator(TinyHashSet<T> parent, T elem1, T elem2) {
            this.parent = parent;
            this.elem1 = elem1;
            this.elem2 = elem2;
            this.returnedElem1 = elem1 == null;
            this.returnedElem2 = elem2 == null;
        }

        @Override
        public boolean hasNext() {
            return !this.returnedElem1 || !this.returnedElem2;
        }

        @Override
        public T next() {
            if (!this.returnedElem1) {
                this.returnedElem1 = true;
                return this.elem1;
            }
            if (!this.returnedElem2) {
                this.returnedElem2 = true;
                return this.elem2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.returnedElem2 && this.elem2 != null) {
                ((TinyHashSet)this.parent).elem2 = null;
                return;
            }
            if (this.returnedElem1 && this.elem1 != null) {
                ((TinyHashSet)this.parent).elem1 = null;
                return;
            }
            EnvironmentFailureException.assertState(false);
        }
    }
}

