/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RulePredicates {
    private static final Logger LOGGER = LoggerFactory.getLogger(RulePredicates.class);
    public static final String ALL_PORTS = "ALL";
    public static final String ALL_USERS = "ALL";
    private static final String TIME_PERIOD_DELIMITER = "/";
    private static final Duration HOUR = Duration.ofHours(1L);
    private static final Duration MINUTE = Duration.ofMinutes(1L);
    private static final Duration SECOND = Duration.ofSeconds(1L);
    private Integer _connectionCountLimit;
    private Integer _connectionFrequencyLimit;
    private Duration _connectionFrequencyPeriod;
    private boolean _blocked = false;
    private final Set<Property> _properties = EnumSet.noneOf(Property.class);
    private String _port = "ALL";

    public static boolean isAllPort(String port) {
        return "ALL".equalsIgnoreCase(port);
    }

    public static boolean isAllUser(String port) {
        return "ALL".equalsIgnoreCase(port);
    }

    public Property parse(String key, String value) {
        Property property = Property.parse(key);
        if (property != null) {
            this.addProperty(property, value);
        }
        return property;
    }

    void addProperty(Property property, String value) {
        this.checkPropertyAlreadyDefined(property);
        switch (property) {
            case PORT: {
                this._port = value.trim();
                break;
            }
            case CONNECTION_LIMIT: {
                this._connectionCountLimit = this.validateCounterLimit(Property.CONNECTION_LIMIT, Integer.parseInt(value));
                break;
            }
            case CONNECTION_FREQUENCY_LIMIT: {
                this.addFrequencyLimit(value);
                break;
            }
        }
        LOGGER.debug("Parsed {} with value {}", (Object)property, (Object)value);
    }

    private void addFrequencyLimit(String value) {
        if (value.contains(TIME_PERIOD_DELIMITER)) {
            String[] frequencyLimit = value.split(TIME_PERIOD_DELIMITER, 2);
            this._connectionFrequencyLimit = this.validateCounterLimit(Property.CONNECTION_FREQUENCY_LIMIT, Integer.parseInt(frequencyLimit[0]));
            this._connectionFrequencyPeriod = this.validateTimePeriod(this.parseTimePeriod(frequencyLimit[1]));
        } else {
            this._connectionFrequencyLimit = this.validateCounterLimit(Property.CONNECTION_FREQUENCY_LIMIT, Integer.parseInt(value));
            this._connectionFrequencyPeriod = null;
        }
    }

    private Duration validateTimePeriod(Duration period) {
        if (period != null && period.isNegative()) {
            throw new IllegalArgumentException(String.format("Frequency period can not be negative %d s", period.getSeconds()));
        }
        return period;
    }

    private Duration parseTimePeriod(String period) {
        if ("Second".equalsIgnoreCase(period)) {
            return SECOND;
        }
        if ("Minute".equalsIgnoreCase(period)) {
            return MINUTE;
        }
        if ("Hour".equalsIgnoreCase(period)) {
            return HOUR;
        }
        if (period.matches("\\d+.*")) {
            return Duration.parse("PT" + period);
        }
        if (period.matches("[hHmMsS]")) {
            return Duration.parse("PT1" + period);
        }
        return Duration.parse(period);
    }

    private Integer validateCounterLimit(Property property, int limit) {
        if (limit < 0) {
            LOGGER.debug("Negative value of {}, using {} instead", (Object)property, (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
        return limit;
    }

    private void checkPropertyAlreadyDefined(Property property) {
        if (this._properties.contains((Object)property)) {
            throw new IllegalStateException(String.format("Property '%s' has already been defined", new Object[]{property}));
        }
        this._properties.add(property);
    }

    public Integer getConnectionCountLimit() {
        return this._connectionCountLimit;
    }

    public Integer getConnectionFrequencyLimit() {
        return this._connectionFrequencyLimit;
    }

    public Duration getConnectionFrequencyPeriod() {
        return this._connectionFrequencyPeriod;
    }

    public boolean isUserBlocked() {
        return this._blocked;
    }

    public String getPort() {
        return this._port;
    }

    public void setBlockedUser() {
        this._blocked = true;
    }

    public boolean isEmpty() {
        return !this._blocked && this._connectionCountLimit == null && this._connectionFrequencyLimit == null;
    }

    public static enum Property {
        PORT,
        CONNECTION_LIMIT,
        CONNECTION_FREQUENCY_LIMIT;

        private static final Map<String, Property> NAME_TO_PROPERTY;

        public static Property parse(String text) {
            return NAME_TO_PROPERTY.get(text.toLowerCase(Locale.ENGLISH).trim());
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            NAME_TO_PROPERTY = new HashMap<String, Property>();
            for (Property property : Property.values()) {
                NAME_TO_PROPERTY.put(property.name().toLowerCase(Locale.ENGLISH), property);
                NAME_TO_PROPERTY.put(property.name().replace("_", "").toLowerCase(Locale.ENGLISH), property);
                NAME_TO_PROPERTY.put(property.name().replace("_", "-").toLowerCase(Locale.ENGLISH), property);
            }
        }
    }
}

