/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Frame;
import org.eclipse.jetty.websocket.core.CloseStatus;

public class JettyWebSocketFrame
implements Frame {
    private final org.eclipse.jetty.websocket.core.Frame frame;
    private final byte effectiveOpCode;

    @Deprecated(forRemoval=true, since="12.1.0")
    public JettyWebSocketFrame(org.eclipse.jetty.websocket.core.Frame frame) {
        this(frame, frame.getOpCode());
    }

    JettyWebSocketFrame(org.eclipse.jetty.websocket.core.Frame frame, byte effectiveOpCode) {
        this.frame = frame;
        this.effectiveOpCode = effectiveOpCode;
    }

    public byte[] getMask() {
        return this.frame.getMask();
    }

    public byte getOpCode() {
        return this.frame.getOpCode();
    }

    public ByteBuffer getPayload() {
        return this.frame.getPayload().asReadOnlyBuffer();
    }

    public int getPayloadLength() {
        return this.frame.getPayloadLength();
    }

    public Frame.Type getType() {
        return Frame.Type.from((byte)this.getOpCode());
    }

    public boolean hasPayload() {
        return this.frame.hasPayload();
    }

    public boolean isFin() {
        return this.frame.isFin();
    }

    public boolean isMasked() {
        return this.frame.isMasked();
    }

    public boolean isRsv1() {
        return this.frame.isRsv1();
    }

    public boolean isRsv2() {
        return this.frame.isRsv2();
    }

    public boolean isRsv3() {
        return this.frame.isRsv3();
    }

    public byte getEffectiveOpCode() {
        return this.effectiveOpCode;
    }

    public Frame.CloseStatus getCloseStatus() {
        if (this.getOpCode() != 8) {
            return null;
        }
        CloseStatus closeStatus = CloseStatus.getCloseStatus((org.eclipse.jetty.websocket.core.Frame)this.frame);
        return new Frame.CloseStatus(closeStatus.getCode(), closeStatus.getReason());
    }

    public String toString() {
        return this.frame.toString();
    }
}

