/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.consumer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.FilterExpression;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.Subscription;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.stub.StreamObserver;
import io.netty.channel.Channel;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PopStatus;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.grpc.v2.AbstractMessingActivity;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcConverter;
import org.apache.rocketmq.proxy.grpc.v2.consumer.PopMessageResultFilterImpl;
import org.apache.rocketmq.proxy.grpc.v2.consumer.ReceiveMessageResponseStreamWriter;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.processor.QueueSelector;
import org.apache.rocketmq.proxy.processor.ReceiptHandleProcessor;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.proxy.service.route.MessageQueueSelector;
import org.apache.rocketmq.proxy.service.route.MessageQueueView;
import org.apache.rocketmq.remoting.protocol.filter.FilterAPI;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class ReceiveMessageActivity
extends AbstractMessingActivity {
    protected ReceiptHandleProcessor receiptHandleProcessor;
    private static final String ILLEGAL_POLLING_TIME_INTRODUCED_CLIENT_VERSION = "5.0.3";

    public ReceiveMessageActivity(MessagingProcessor messagingProcessor, ReceiptHandleProcessor receiptHandleProcessor, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager) {
        super(messagingProcessor, grpcClientSettingsManager, grpcChannelManager);
        this.receiptHandleProcessor = receiptHandleProcessor;
    }

    public void receiveMessage(ProxyContext ctx, ReceiveMessageRequest request, StreamObserver<ReceiveMessageResponse> responseObserver) {
        ReceiveMessageResponseStreamWriter writer = this.createWriter(ctx, responseObserver);
        try {
            SubscriptionData subscriptionData;
            Settings settings = this.grpcClientSettingsManager.getClientSettings(ctx);
            Subscription subscription = settings.getSubscription();
            boolean fifo = subscription.getFifo();
            int maxAttempts = settings.getBackoffPolicy().getMaxAttempts();
            ProxyConfig config = ConfigurationManager.getProxyConfig();
            Long timeRemaining = ctx.getRemainingMs();
            long pollingTime = request.hasLongPollingTimeout() ? Durations.toMillis((Duration)request.getLongPollingTimeout()) : timeRemaining - Durations.toMillis((Duration)settings.getRequestTimeout()) / 2L;
            if (pollingTime < config.getGrpcClientConsumerMinLongPollingTimeoutMillis()) {
                pollingTime = config.getGrpcClientConsumerMinLongPollingTimeoutMillis();
            }
            if (pollingTime > config.getGrpcClientConsumerMaxLongPollingTimeoutMillis()) {
                pollingTime = config.getGrpcClientConsumerMaxLongPollingTimeoutMillis();
            }
            if (pollingTime > timeRemaining) {
                if (timeRemaining >= config.getGrpcClientConsumerMinLongPollingTimeoutMillis()) {
                    pollingTime = timeRemaining;
                } else {
                    String clientVersion = ctx.getClientVersion();
                    Code code = null == clientVersion || ILLEGAL_POLLING_TIME_INTRODUCED_CLIENT_VERSION.compareTo(clientVersion) > 0 ? Code.BAD_REQUEST : Code.ILLEGAL_POLLING_TIME;
                    writer.writeAndComplete(ctx, code, "The deadline time remaining is not enough for polling, please check network condition");
                    return;
                }
            }
            this.validateTopicAndConsumerGroup(request.getMessageQueue().getTopic(), request.getGroup());
            String topic = GrpcConverter.getInstance().wrapResourceWithNamespace(request.getMessageQueue().getTopic());
            String group = GrpcConverter.getInstance().wrapResourceWithNamespace(request.getGroup());
            long actualInvisibleTime = Durations.toMillis((Duration)request.getInvisibleDuration());
            ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
            if (proxyConfig.isEnableProxyAutoRenew() && request.getAutoRenew()) {
                actualInvisibleTime = proxyConfig.getDefaultInvisibleTimeMills();
            } else {
                this.validateInvisibleTime(actualInvisibleTime, ConfigurationManager.getProxyConfig().getMinInvisibleTimeMillsForRecv());
            }
            FilterExpression filterExpression = request.getFilterExpression();
            try {
                subscriptionData = FilterAPI.build((String)topic, (String)filterExpression.getExpression(), (String)GrpcConverter.getInstance().buildExpressionType(filterExpression.getType()));
            }
            catch (Exception e) {
                writer.writeAndComplete(ctx, Code.ILLEGAL_FILTER_EXPRESSION, e.getMessage());
                return;
            }
            ((CompletableFuture)this.messagingProcessor.popMessage(ctx, new ReceiveMessageQueueSelector(request.getMessageQueue().getBroker().getName()), group, topic, request.getBatchSize(), actualInvisibleTime, pollingTime, 1, subscriptionData, fifo, new PopMessageResultFilterImpl(maxAttempts), timeRemaining).thenAccept(popResult -> {
                if (proxyConfig.isEnableProxyAutoRenew() && request.getAutoRenew() && PopStatus.FOUND.equals((Object)popResult.getPopStatus())) {
                    List messageExtList = popResult.getMsgFoundList();
                    for (MessageExt messageExt : messageExtList) {
                        String receiptHandle = messageExt.getProperty("POP_CK");
                        if (receiptHandle == null) continue;
                        MessageReceiptHandle messageReceiptHandle = new MessageReceiptHandle(group, topic, messageExt.getQueueId(), receiptHandle, messageExt.getMsgId(), messageExt.getQueueOffset(), messageExt.getReconsumeTimes());
                        this.receiptHandleProcessor.addReceiptHandle((Channel)this.grpcChannelManager.getChannel(ctx.getClientID()), group, messageExt.getMsgId(), receiptHandle, messageReceiptHandle);
                    }
                }
                writer.writeAndComplete(ctx, request, (PopResult)popResult);
            })).exceptionally(t -> {
                writer.writeAndComplete(ctx, request, (Throwable)t);
                return null;
            });
        }
        catch (Throwable t2) {
            writer.writeAndComplete(ctx, request, t2);
        }
    }

    protected ReceiveMessageResponseStreamWriter createWriter(ProxyContext ctx, StreamObserver<ReceiveMessageResponse> responseObserver) {
        return new ReceiveMessageResponseStreamWriter(this.messagingProcessor, responseObserver);
    }

    protected static class ReceiveMessageQueueSelector
    implements QueueSelector {
        private final String brokerName;

        public ReceiveMessageQueueSelector(String brokerName) {
            this.brokerName = brokerName;
        }

        @Override
        public AddressableMessageQueue select(ProxyContext ctx, MessageQueueView messageQueueView) {
            try {
                AddressableMessageQueue addressableMessageQueue = null;
                MessageQueueSelector messageQueueSelector = messageQueueView.getReadSelector();
                if (StringUtils.isNotBlank((CharSequence)this.brokerName)) {
                    addressableMessageQueue = messageQueueSelector.getQueueByBrokerName(this.brokerName);
                }
                if (addressableMessageQueue == null) {
                    addressableMessageQueue = messageQueueSelector.selectOne(true);
                }
                return addressableMessageQueue;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

