"use strict";
exports.ja = void 0;
var _index = require("./ja/_lib/formatDistance.js");
var _index2 = require("./ja/_lib/formatLong.js");
var _index3 = require("./ja/_lib/formatRelative.js");
var _index4 = require("./ja/_lib/localize.js");
var _index5 = require("./ja/_lib/match.js");

/**
 * @category Locales
 * @summary Japanese locale.
 * @language Japanese
 * @iso-639-2 jpn
 * @author Thomas Eilmsteiner [@DeMuu](https://github.com/DeMuu)
 * @author Yamagishi Kazutoshi [@ykzts](https://github.com/ykzts)
 * @author Luca Ban [@mesqueeb](https://github.com/mesqueeb)
 * @author Terrence Lam [@skyuplam](https://github.com/skyuplam)
 * @author Taiki IKeda [@so99ynoodles](https://github.com/so99ynoodles)
 */
const ja = (exports.ja = {
  code: "ja",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 0 /* Sunday */,
    firstWeekContainsDate: 1,
  },
});
