/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.servicecomb.common.rest.RestProducerInvocationFlow;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.StandardHttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.StandardHttpServletResponseEx;
import org.apache.servicecomb.transport.rest.servlet.RestAsyncListener;
import org.apache.servicecomb.transport.rest.servlet.RestServletProducerInvocationCreator;
import org.apache.servicecomb.transport.rest.servlet.ServletConfig;

public class ServletRestDispatcher {
    private final RestAsyncListener restAsyncListener = new RestAsyncListener();
    private Transport transport;
    private MicroserviceMeta microserviceMeta;

    public void service(HttpServletRequest request, HttpServletResponse response) {
        if (this.transport == null) {
            this.transport = SCBEngine.getInstance().getTransportManager().findTransport("rest");
            this.microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        }
        AsyncContext asyncCtx = request.startAsync();
        asyncCtx.addListener((AsyncListener)this.restAsyncListener);
        asyncCtx.setTimeout(ServletConfig.getAsyncServletTimeout(SCBEngine.getInstance().getEnvironment()));
        StandardHttpServletRequestEx requestEx = new StandardHttpServletRequestEx(request);
        StandardHttpServletResponseEx responseEx = new StandardHttpServletResponseEx(response);
        requestEx.setCacheRequest(true);
        RestServletProducerInvocationCreator creator = new RestServletProducerInvocationCreator(this.microserviceMeta, this.transport.getEndpoint(), (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx);
        new RestProducerInvocationFlow((InvocationCreator)creator, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx).run();
    }
}

