/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import java.io.IOException;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class DeserializationUtils {
    public static JsonNode deserializeIntoTree(String contents, String fileOrHost) {
        JsonNode result;
        try {
            result = DeserializationUtils.isJson(contents) ? Json.mapper().readTree(contents) : DeserializationUtils.readYamlTree(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into a JsonNode tree", e);
        }
        return result;
    }

    public static <T> T deserialize(Object contents, String fileOrHost, Class<T> expectedType) {
        Object result;
        boolean isJson = false;
        if (contents instanceof String && DeserializationUtils.isJson((String)contents)) {
            isJson = true;
        }
        try {
            result = contents instanceof String ? (isJson ? Json.mapper().readValue((String)contents, expectedType) : Yaml.mapper().readValue((String)contents, expectedType)) : Json.mapper().convertValue(contents, expectedType);
        }
        catch (Exception e) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into type " + expectedType, e);
        }
        return (T)result;
    }

    private static boolean isJson(String contents) {
        return contents.toString().trim().startsWith("{");
    }

    public static JsonNode readYamlTree(String contents) {
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml((BaseConstructor)new SafeConstructor());
        return (JsonNode)Json.mapper().convertValue(yaml.load(contents), JsonNode.class);
    }

    public static <T> T readYamlValue(String contents, Class<T> expectedType) {
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml((BaseConstructor)new SafeConstructor());
        return (T)Json.mapper().convertValue(yaml.load(contents), expectedType);
    }
}

