/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.tcp;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.ConversionUtils;
import com.tencent.polaris.api.utils.IOUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.tcp.Config;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;

public class TcpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TcpHealthChecker.class);
    private FaultDetectorProto.TcpProtocolConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DetectResult detectInstance(Instance instance, FaultDetectorProto.FaultDetectRule faultDetectRule) throws PolarisException {
        Object object;
        Socket socket;
        long startTimeMillis;
        int port;
        String host;
        block34: {
            long delayMillis;
            block32: {
                block33: {
                    ArrayList<byte[]> expectRecvStrs;
                    block30: {
                        DetectResult e222;
                        block31: {
                            byte[] sendBytes;
                            int timeoutMs;
                            block28: {
                                DetectResult detectResult;
                                block29: {
                                    boolean needSendData;
                                    host = instance.getHost();
                                    port = instance.getPort();
                                    FaultDetectorProto.TcpProtocolConfig curConfig = this.config;
                                    timeoutMs = 1000;
                                    if (null != faultDetectRule && faultDetectRule.getProtocol() == FaultDetectorProto.FaultDetectRule.Protocol.TCP) {
                                        if (faultDetectRule.getTimeout() > 0) {
                                            timeoutMs = faultDetectRule.getTimeout();
                                        }
                                        if (faultDetectRule.getPort() > 0) {
                                            port = faultDetectRule.getPort();
                                        }
                                        curConfig = faultDetectRule.getTcpConfig();
                                    }
                                    sendBytes = null;
                                    int maxLength = 0;
                                    expectRecvStrs = new ArrayList<byte[]>();
                                    if (null != curConfig) {
                                        if (StringUtils.isNotBlank(curConfig.getSend())) {
                                            sendBytes = ConversionUtils.anyStringToByte(curConfig.getSend());
                                        }
                                        for (String receiveStr : curConfig.getReceiveList()) {
                                            byte[] receiveBytes = ConversionUtils.anyStringToByte(receiveStr);
                                            if (receiveBytes.length > maxLength) {
                                                maxLength = receiveBytes.length;
                                            }
                                            expectRecvStrs.add(receiveBytes);
                                        }
                                    }
                                    startTimeMillis = System.currentTimeMillis();
                                    socket = null;
                                    socket = new Socket(host, port);
                                    boolean bl = needSendData = null != sendBytes && sendBytes.length > 0;
                                    if (needSendData) break block28;
                                    long delayMillis2 = System.currentTimeMillis() - startTimeMillis;
                                    detectResult = new DetectResult(0, delayMillis2, RetStatus.RetSuccess);
                                    if (socket == null) break block29;
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException e222) {
                                        LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e222});
                                    }
                                }
                                return detectResult;
                            }
                            socket.setSoTimeout(timeoutMs);
                            OutputStream os = socket.getOutputStream();
                            os.write(sendBytes);
                            os.flush();
                            delayMillis = System.currentTimeMillis() - startTimeMillis;
                            if (!expectRecvStrs.isEmpty()) break block30;
                            e222 = new DetectResult(0, delayMillis, RetStatus.RetSuccess);
                            if (socket == null) break block31;
                            try {
                                socket.close();
                            }
                            catch (IOException e3) {
                                LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e3});
                            }
                        }
                        return e222;
                    }
                    byte[] recvBytes = this.recvFromSocket(socket);
                    System.out.println("[TCP] checker receive bytes " + new String(recvBytes));
                    boolean found = false;
                    for (byte[] expectRecvStr : expectRecvStrs) {
                        byte[] recvBytesClone;
                        if (!Arrays.equals(expectRecvStr, recvBytesClone = Arrays.copyOfRange(recvBytes, 0, expectRecvStr.length))) continue;
                        found = true;
                        break;
                    }
                    if (!found) break block32;
                    object = new DetectResult(0, delayMillis, RetStatus.RetSuccess);
                    if (socket == null) break block33;
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e});
                    }
                }
                return object;
            }
            object = new DetectResult(-1, delayMillis, RetStatus.RetFail);
            if (socket == null) break block34;
            try {
                socket.close();
            }
            catch (IOException e) {
                LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e});
            }
        }
        return object;
        catch (IOException e) {
            DetectResult detectResult;
            block35: {
                try {
                    LOG.warn("tcp detect instance, create sock exception, host:{}, port:{}, error {}", new Object[]{host, port, e.getMessage()});
                    long delayMillis2 = System.currentTimeMillis() - startTimeMillis;
                    detectResult = new DetectResult(-1, delayMillis2, RetStatus.RetFail);
                    if (socket == null) break block35;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e4) {
                            LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e4});
                        }
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException e5) {
                    LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e5});
                }
            }
            return detectResult;
        }
    }

    private byte[] recvFromSocket(Socket socket) throws IOException {
        InputStream is = socket.getInputStream();
        byte[] recvBytes = new byte[1024];
        int read = IOUtils.read(is, recvBytes, 0, recvBytes.length);
        return Arrays.copyOfRange(recvBytes, 0, read);
    }

    @Override
    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "tcp";
    }

    @Override
    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = outlierDetection.getPluginConfig(this.getName(), Config.class);
        FaultDetectorProto.TcpProtocolConfig.Builder builder = FaultDetectorProto.TcpProtocolConfig.newBuilder();
        if (null != cfg && StringUtils.isNotBlank(cfg.getSend())) {
            builder.setSend(cfg.getSend());
        }
        if (null != cfg && StringUtils.isNotBlank(cfg.getReceive())) {
            builder.addReceive(cfg.getReceive());
        }
        this.config = builder.build();
    }

    @Override
    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    @Override
    public void destroy() {
    }
}

