/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.api.rpc;

import com.tencent.polaris.api.utils.StringUtils;
import java.util.Map;
import java.util.Objects;

public class Argument {
    private final ArgumentType type;
    private final String key;
    private final String value;

    private Argument(ArgumentType type, String key, String value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public ArgumentType getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static Argument buildCustom(String key, String value) {
        return new Argument(ArgumentType.CUSTOM, StringUtils.defaultString(key), StringUtils.defaultString(value));
    }

    public static Argument buildMethod(String method) {
        return new Argument(ArgumentType.METHOD, "", StringUtils.defaultString(method));
    }

    public static Argument buildHeader(String headerKey, String headerValue) {
        return new Argument(ArgumentType.HEADER, StringUtils.defaultString(headerKey), StringUtils.defaultString(headerValue));
    }

    public static Argument buildQuery(String queryKey, String queryValue) {
        return new Argument(ArgumentType.QUERY, StringUtils.defaultString(queryKey), StringUtils.defaultString(queryValue));
    }

    public static Argument buildCallerService(String namespace, String service) {
        return new Argument(ArgumentType.CALLER_SERVICE, StringUtils.defaultString(namespace), StringUtils.defaultString(service));
    }

    public static Argument buildCallerIP(String callerIP) {
        return new Argument(ArgumentType.CALLER_IP, "", StringUtils.defaultString(callerIP));
    }

    public static Argument fromLabel(String labelKey, String labelValue) {
        if (StringUtils.equals(labelKey = StringUtils.defaultString(labelKey), "$method")) {
            return Argument.buildMethod(labelValue);
        }
        if (StringUtils.equals(labelKey, "$caller_ip")) {
            return Argument.buildCallerIP(labelValue);
        }
        if (labelKey.startsWith("$header.")) {
            return Argument.buildHeader(labelKey.substring("$header.".length()), labelValue);
        }
        if (labelKey.startsWith("$query.")) {
            return Argument.buildQuery(labelKey.substring("$query.".length()), labelValue);
        }
        if (labelKey.startsWith("$caller_service.")) {
            return Argument.buildCallerService(labelKey.substring("$caller_service.".length()), labelValue);
        }
        return Argument.buildCustom(labelKey, labelValue);
    }

    public void toLabel(Map<String, String> labels) {
        switch (this.type) {
            case METHOD: {
                labels.put("$method", this.value);
                break;
            }
            case CALLER_IP: {
                labels.put("$caller_ip", this.value);
                break;
            }
            case HEADER: {
                labels.put("$header." + this.key, this.value);
                break;
            }
            case QUERY: {
                labels.put("$query." + this.key, this.value);
                break;
            }
            case CALLER_SERVICE: {
                labels.put("$caller_service." + this.key, this.value);
                break;
            }
            case CUSTOM: {
                labels.put(this.key, this.value);
                break;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument that = (Argument)o;
        return this.type == that.type && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.value});
    }

    public String toString() {
        return "MatchArgument{type=" + (Object)((Object)this.type) + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static enum ArgumentType {
        CUSTOM,
        METHOD,
        HEADER,
        QUERY,
        CALLER_SERVICE,
        CALLER_IP;

    }
}

