/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;
import reactor.netty.internal.util.MapUtils;
import reactor.netty.transport.EventLoopMeters;

final class MicrometerEventLoopMeterRegistrar {
    static final MicrometerEventLoopMeterRegistrar INSTANCE = new MicrometerEventLoopMeterRegistrar();
    private final ConcurrentMap<String, EventLoop> cache = new ConcurrentHashMap<String, EventLoop>();

    private MicrometerEventLoopMeterRegistrar() {
    }

    void registerMetrics(EventLoop eventLoop) {
        if (eventLoop instanceof SingleThreadEventExecutor) {
            SingleThreadEventExecutor singleThreadEventExecutor = (SingleThreadEventExecutor)eventLoop;
            String executorName = singleThreadEventExecutor.threadProperties().name();
            MapUtils.computeIfAbsent(this.cache, executorName, key -> {
                Gauge.builder((String)EventLoopMeters.PENDING_TASKS.getName(), () -> ((SingleThreadEventExecutor)singleThreadEventExecutor).pendingTasks()).tag(EventLoopMeters.EventLoopMetersTags.NAME.asString(), executorName).register(Metrics.REGISTRY);
                return eventLoop;
            });
        }
    }
}

