/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.sumpermin;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@MeterFunction(functionName="sumPerMin")
public abstract class SumPerMinFunction
extends Meter
implements AcceptableValue<Long>,
LongValueHolder {
    protected static final String VALUE = "value";
    protected static final String TOTAL = "total";
    @ElasticSearch.EnableDocValues
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="service_id")
    private String serviceId;
    @ElasticSearch.EnableDocValues
    @Column(name="value", dataType=Column.ValueDataType.COMMON_VALUE)
    @BanyanDB.MeasureField
    private long value;
    @Column(name="total", storageOnly=true)
    @BanyanDB.MeasureField
    private long total;

    @Override
    public boolean combine(Metrics metrics) {
        SumPerMinFunction sumPerMinFunction = (SumPerMinFunction)metrics;
        this.total += sumPerMinFunction.getTotal();
        return true;
    }

    @Override
    public void calculate() {
        this.setValue(this.total / this.getDurationInMinute());
    }

    @Override
    public Metrics toHour() {
        SumPerMinFunction metrics = (SumPerMinFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.setTotal(this.getTotal());
        metrics.setAttr0(this.getAttr0());
        metrics.setAttr1(this.getAttr1());
        metrics.setAttr2(this.getAttr2());
        metrics.setAttr3(this.getAttr3());
        metrics.setAttr4(this.getAttr4());
        metrics.setAttr5(this.getAttr5());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        SumPerMinFunction metrics = (SumPerMinFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.setTotal(this.getTotal());
        metrics.setAttr0(this.getAttr0());
        metrics.setAttr1(this.getAttr1());
        metrics.setAttr2(this.getAttr2());
        metrics.setAttr3(this.getAttr3());
        metrics.setAttr4(this.getAttr4());
        metrics.setAttr5(this.getAttr5());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.getEntityId().hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTotal(remoteData.getDataLongs(0));
        this.setTimeBucket(remoteData.getDataLongs(1));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setServiceId(remoteData.getDataStrings(1));
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(2))) {
            this.setAttr0(remoteData.getDataStrings(2));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(3))) {
            this.setAttr1(remoteData.getDataStrings(3));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(4))) {
            this.setAttr2(remoteData.getDataStrings(4));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(5))) {
            this.setAttr3(remoteData.getDataStrings(5));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(6))) {
            this.setAttr4(remoteData.getDataStrings(6));
        }
        if (StringUtil.isNotEmpty((String)remoteData.getDataStrings(7))) {
            this.setAttr5(remoteData.getDataStrings(7));
        }
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTotal());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataStrings(this.getServiceId());
        remoteBuilder.addDataStrings(this.getAttr0() == null ? "" : this.getAttr0());
        remoteBuilder.addDataStrings(this.getAttr1() == null ? "" : this.getAttr1());
        remoteBuilder.addDataStrings(this.getAttr2() == null ? "" : this.getAttr2());
        remoteBuilder.addDataStrings(this.getAttr3() == null ? "" : this.getAttr3());
        remoteBuilder.addDataStrings(this.getAttr4() == null ? "" : this.getAttr4());
        remoteBuilder.addDataStrings(this.getAttr5() == null ? "" : this.getAttr5());
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public void accept(MeterEntity entity, Long value) {
        this.decorate(entity);
        this.setEntityId(entity.id());
        this.setServiceId(entity.serviceId());
        this.setTotal(this.getTotal() + value);
    }

    @Override
    public Class<? extends StorageBuilder> builder() {
        return SumPerMinStorageBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SumPerMinFunction)) {
            return false;
        }
        SumPerMinFunction function = (SumPerMinFunction)o;
        return Objects.equals(this.getEntityId(), function.getEntityId()) && Objects.equals(this.getTimeBucket(), function.getTimeBucket());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getEntityId(), this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "SumPerMinFunction(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", value=" + this.getValue() + ", total=" + this.getTotal() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long value) {
        this.value = value;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    public static class SumPerMinStorageBuilder
    implements StorageBuilder<SumPerMinFunction> {
        @Override
        public SumPerMinFunction storage2Entity(Convert2Entity converter) {
            SumPerMinFunction metrics = new SumPerMinFunction(){

                @Override
                public AcceptableValue<Long> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setValue(((Number)converter.get(SumPerMinFunction.VALUE)).longValue());
            metrics.setTotal(((Number)converter.get(SumPerMinFunction.TOTAL)).longValue());
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            metrics.setAttr0((String)converter.get("attr0"));
            metrics.setAttr1((String)converter.get("attr1"));
            metrics.setAttr2((String)converter.get("attr2"));
            metrics.setAttr3((String)converter.get("attr3"));
            metrics.setAttr4((String)converter.get("attr4"));
            metrics.setAttr5((String)converter.get("attr5"));
            return metrics;
        }

        @Override
        public void entity2Storage(SumPerMinFunction storageData, Convert2Storage converter) {
            converter.accept(SumPerMinFunction.VALUE, storageData.getValue());
            converter.accept(SumPerMinFunction.TOTAL, storageData.getTotal());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
            converter.accept("attr0", storageData.getAttr0());
            converter.accept("attr1", storageData.getAttr1());
            converter.accept("attr2", storageData.getAttr2());
            converter.accept("attr3", storageData.getAttr3());
            converter.accept("attr4", storageData.getAttr4());
            converter.accept("attr5", storageData.getAttr5());
        }
    }
}

