/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;

@MetricsFunction(functionName="doubleAvg")
public abstract class DoubleAvgMetrics
extends Metrics
implements DoubleValueHolder {
    protected static final String SUMMATION = "double_summation";
    protected static final String COUNT = "count";
    protected static final String VALUE = "double_value";
    @Column(name="double_summation", storageOnly=true)
    @ElasticSearch.Column(legacyName="summation")
    @BanyanDB.MeasureField
    private double summation;
    @Column(name="count", storageOnly=true)
    @BanyanDB.MeasureField
    private long count;
    @ElasticSearch.EnableDocValues
    @Column(name="double_value", dataType=Column.ValueDataType.COMMON_VALUE)
    @ElasticSearch.Column(legacyName="value")
    @BanyanDB.MeasureField
    private double value;

    @Entrance
    public final void combine(@SourceFrom double summation, @ConstOne long count) {
        this.summation += summation;
        this.count += count;
    }

    @Override
    public final boolean combine(Metrics metrics) {
        DoubleAvgMetrics doubleAvgMetrics = (DoubleAvgMetrics)metrics;
        this.combine(doubleAvgMetrics.summation, doubleAvgMetrics.count);
        return true;
    }

    @Override
    public final void calculate() {
        this.value = this.summation / (double)this.count;
    }

    @Generated
    public double getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(double summation) {
        this.summation = summation;
    }

    @Generated
    public long getCount() {
        return this.count;
    }

    @Generated
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public void setValue(double value) {
        this.value = value;
    }
}

