/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.hierarchy.instance;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="instance_hierarchy_relation", scopeId=71, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
@BanyanDB.IndexMode
public class InstanceHierarchyRelationTraffic
extends Metrics {
    public static final String INDEX_NAME = "instance_hierarchy_relation";
    public static final String SERVICE_LAYER = "service_layer";
    public static final String INSTANCE_ID = "instance_id";
    public static final String RELATED_SERVICE_LAYER = "related_service_layer";
    public static final String RELATED_INSTANCE_ID = "related_instance_id";
    @Column(name="instance_id", length=250)
    private String instanceId;
    @Column(name="service_layer")
    private Layer serviceLayer = Layer.UNDEFINED;
    @Column(name="related_instance_id", length=250)
    private String relatedInstanceId;
    @Column(name="related_service_layer")
    private Layer relatedServiceLayer = Layer.UNDEFINED;

    @Override
    protected StorageID id0() {
        String id = IDManager.ServiceInstanceID.buildInstanceHierarchyRelationId(new IDManager.ServiceInstanceID.InstanceHierarchyRelationDefine(this.instanceId, this.serviceLayer, this.relatedInstanceId, this.relatedServiceLayer));
        return new StorageID().append(id);
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setInstanceId(remoteData.getDataStrings(0));
        this.setServiceLayer(Layer.valueOf(remoteData.getDataIntegers(0)));
        this.setRelatedInstanceId(remoteData.getDataStrings(1));
        this.setRelatedServiceLayer(Layer.valueOf(remoteData.getDataIntegers(1)));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.instanceId);
        builder.addDataIntegers(this.serviceLayer.value());
        builder.addDataStrings(this.relatedInstanceId);
        builder.addDataIntegers(this.relatedServiceLayer.value());
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceHierarchyRelationTraffic)) {
            return false;
        }
        InstanceHierarchyRelationTraffic other = (InstanceHierarchyRelationTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        Layer this$serviceLayer = this.getServiceLayer();
        Layer other$serviceLayer = other.getServiceLayer();
        if (this$serviceLayer == null ? other$serviceLayer != null : !((Object)((Object)this$serviceLayer)).equals((Object)other$serviceLayer)) {
            return false;
        }
        String this$relatedInstanceId = this.getRelatedInstanceId();
        String other$relatedInstanceId = other.getRelatedInstanceId();
        if (this$relatedInstanceId == null ? other$relatedInstanceId != null : !this$relatedInstanceId.equals(other$relatedInstanceId)) {
            return false;
        }
        Layer this$relatedServiceLayer = this.getRelatedServiceLayer();
        Layer other$relatedServiceLayer = other.getRelatedServiceLayer();
        return !(this$relatedServiceLayer == null ? other$relatedServiceLayer != null : !((Object)((Object)this$relatedServiceLayer)).equals((Object)other$relatedServiceLayer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InstanceHierarchyRelationTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        Layer $serviceLayer = this.getServiceLayer();
        result = result * 59 + ($serviceLayer == null ? 43 : ((Object)((Object)$serviceLayer)).hashCode());
        String $relatedInstanceId = this.getRelatedInstanceId();
        result = result * 59 + ($relatedInstanceId == null ? 43 : $relatedInstanceId.hashCode());
        Layer $relatedServiceLayer = this.getRelatedServiceLayer();
        result = result * 59 + ($relatedServiceLayer == null ? 43 : ((Object)((Object)$relatedServiceLayer)).hashCode());
        return result;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public void setServiceLayer(Layer serviceLayer) {
        this.serviceLayer = serviceLayer;
    }

    @Generated
    public Layer getServiceLayer() {
        return this.serviceLayer;
    }

    @Generated
    public void setRelatedInstanceId(String relatedInstanceId) {
        this.relatedInstanceId = relatedInstanceId;
    }

    @Generated
    public String getRelatedInstanceId() {
        return this.relatedInstanceId;
    }

    @Generated
    public void setRelatedServiceLayer(Layer relatedServiceLayer) {
        this.relatedServiceLayer = relatedServiceLayer;
    }

    @Generated
    public Layer getRelatedServiceLayer() {
        return this.relatedServiceLayer;
    }

    public static class Builder
    implements StorageBuilder<InstanceHierarchyRelationTraffic> {
        @Override
        public InstanceHierarchyRelationTraffic storage2Entity(Convert2Entity converter) {
            InstanceHierarchyRelationTraffic traffic = new InstanceHierarchyRelationTraffic();
            traffic.setInstanceId((String)converter.get(InstanceHierarchyRelationTraffic.INSTANCE_ID));
            traffic.setRelatedInstanceId((String)converter.get(InstanceHierarchyRelationTraffic.RELATED_INSTANCE_ID));
            if (converter.get(InstanceHierarchyRelationTraffic.SERVICE_LAYER) != null) {
                traffic.setServiceLayer(Layer.valueOf(((Number)converter.get(InstanceHierarchyRelationTraffic.SERVICE_LAYER)).intValue()));
            } else {
                traffic.setServiceLayer(Layer.UNDEFINED);
            }
            if (converter.get(InstanceHierarchyRelationTraffic.RELATED_SERVICE_LAYER) != null) {
                traffic.setRelatedServiceLayer(Layer.valueOf(((Number)converter.get(InstanceHierarchyRelationTraffic.RELATED_SERVICE_LAYER)).intValue()));
            } else {
                traffic.setRelatedServiceLayer(Layer.UNDEFINED);
            }
            if (converter.get("time_bucket") != null) {
                traffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            }
            return traffic;
        }

        @Override
        public void entity2Storage(InstanceHierarchyRelationTraffic storageData, Convert2Storage converter) {
            converter.accept(InstanceHierarchyRelationTraffic.INSTANCE_ID, storageData.getInstanceId());
            converter.accept(InstanceHierarchyRelationTraffic.RELATED_INSTANCE_ID, storageData.getRelatedInstanceId());
            converter.accept(InstanceHierarchyRelationTraffic.SERVICE_LAYER, storageData.getServiceLayer().value());
            converter.accept(InstanceHierarchyRelationTraffic.RELATED_SERVICE_LAYER, storageData.getRelatedServiceLayer().value());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

