/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.Source;

@ScopeDeclaration(id=6, name="EndpointRelation", catalog="ENDPOINT_RELATION")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class EndpointRelation
extends Source {
    @ScopeDefaultColumn.DefinedByField(columnName="source_endpoint_name", requireDynamicActive=true)
    private String endpoint;
    private String serviceId;
    @ScopeDefaultColumn.DefinedByField(columnName="source_service_name", requireDynamicActive=true)
    private String serviceName;
    private String serviceInstanceName;
    @ScopeDefaultColumn.DefinedByField(columnName="child_endpoint_name", requireDynamicActive=true)
    private String childEndpoint;
    private String childServiceId;
    @ScopeDefaultColumn.DefinedByField(columnName="child_service_name", requireDynamicActive=true)
    private String childServiceName;
    private String childServiceInstanceName;
    private int componentId;
    private int rpcLatency;
    private boolean status;
    private int httpResponseStatusCode;
    private String rpcStatusCode;
    private RequestType type;
    private DetectPoint detectPoint;
    private Layer serviceLayer;
    private Layer childServiceLayer;

    @Override
    public int scope() {
        return 6;
    }

    @Override
    public String getEntityId() {
        return IDManager.EndpointID.buildRelationId(new IDManager.EndpointID.EndpointRelationDefine(this.serviceId, this.endpoint, this.childServiceId, this.childEndpoint));
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, this.serviceLayer.isNormal());
        this.childServiceId = IDManager.ServiceID.buildId(this.childServiceName, this.childServiceLayer.isNormal());
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public String getChildEndpoint() {
        return this.childEndpoint;
    }

    @Generated
    public void setChildEndpoint(String childEndpoint) {
        this.childEndpoint = childEndpoint;
    }

    @Generated
    public String getChildServiceId() {
        return this.childServiceId;
    }

    @Generated
    public void setChildServiceName(String childServiceName) {
        this.childServiceName = childServiceName;
    }

    @Generated
    public String getChildServiceName() {
        return this.childServiceName;
    }

    @Generated
    public String getChildServiceInstanceName() {
        return this.childServiceInstanceName;
    }

    @Generated
    public void setChildServiceInstanceName(String childServiceInstanceName) {
        this.childServiceInstanceName = childServiceInstanceName;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public int getRpcLatency() {
        return this.rpcLatency;
    }

    @Generated
    public void setRpcLatency(int rpcLatency) {
        this.rpcLatency = rpcLatency;
    }

    @Generated
    public boolean isStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(boolean status) {
        this.status = status;
    }

    @Generated
    public int getHttpResponseStatusCode() {
        return this.httpResponseStatusCode;
    }

    @Generated
    public void setHttpResponseStatusCode(int httpResponseStatusCode) {
        this.httpResponseStatusCode = httpResponseStatusCode;
    }

    @Generated
    public String getRpcStatusCode() {
        return this.rpcStatusCode;
    }

    @Generated
    public void setRpcStatusCode(String rpcStatusCode) {
        this.rpcStatusCode = rpcStatusCode;
    }

    @Generated
    public RequestType getType() {
        return this.type;
    }

    @Generated
    public void setType(RequestType type) {
        this.type = type;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    @Generated
    public Layer getServiceLayer() {
        return this.serviceLayer;
    }

    @Generated
    public void setServiceLayer(Layer serviceLayer) {
        this.serviceLayer = serviceLayer;
    }

    @Generated
    public Layer getChildServiceLayer() {
        return this.childServiceLayer;
    }

    @Generated
    public void setChildServiceLayer(Layer childServiceLayer) {
        this.childServiceLayer = childServiceLayer;
    }
}

