/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.annotation.SuperDataset;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBExtension;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBModelExtension;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.ElasticSearchExtension;
import org.apache.skywalking.oap.server.core.storage.model.ElasticSearchModelExtension;
import org.apache.skywalking.oap.server.core.storage.model.IModelManager;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelManipulator;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseExtension;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseModelExtension;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageModels
implements IModelManager,
ModelCreator,
ModelManipulator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageModels.class);
    private final List<Model> models = new ArrayList<Model>();
    private final HashMap<String, String> columnNameOverrideRule = new HashMap();
    private final List<ModelCreator.CreatingListener> listeners = new ArrayList<ModelCreator.CreatingListener>();

    @Override
    public Model add(Class<?> aClass, int scopeId, Storage storage) throws StorageException {
        DefaultScopeDefine.nameOf(scopeId);
        ArrayList<ModelColumn> modelColumns = new ArrayList<ModelColumn>();
        SeriesIDChecker seriesIDChecker = new SeriesIDChecker();
        ShardingKeyChecker shardingKeyChecker = new ShardingKeyChecker();
        SQLDatabaseModelExtension sqlDBModelExtension = new SQLDatabaseModelExtension();
        BanyanDBModelExtension banyanDBModelExtension = new BanyanDBModelExtension();
        ElasticSearchModelExtension elasticSearchModelExtension = new ElasticSearchModelExtension();
        this.retrieval(aClass, storage.getModelName(), modelColumns, scopeId, seriesIDChecker, shardingKeyChecker, sqlDBModelExtension, banyanDBModelExtension);
        if (aClass.isAnnotationPresent(SQLDatabase.ExtraColumn4AdditionalEntity.class) || aClass.isAnnotationPresent(SQLDatabase.MultipleExtraColumn4AdditionalEntity.class)) {
            HashMap<String, List> extraColumns = new HashMap<String, List>();
            if (aClass.isAnnotationPresent(SQLDatabase.MultipleExtraColumn4AdditionalEntity.class)) {
                for (SQLDatabase.ExtraColumn4AdditionalEntity extraColumn2 : aClass.getAnnotation(SQLDatabase.MultipleExtraColumn4AdditionalEntity.class).value()) {
                    List tables2 = extraColumns.computeIfAbsent(extraColumn2.parentColumn(), v -> new ArrayList());
                    tables2.add(extraColumn2.additionalTable());
                }
            } else {
                SQLDatabase.ExtraColumn4AdditionalEntity extraColumn3 = aClass.getAnnotation(SQLDatabase.ExtraColumn4AdditionalEntity.class);
                List tables3 = extraColumns.computeIfAbsent(extraColumn3.parentColumn(), v -> new ArrayList());
                tables3.add(extraColumn3.additionalTable());
            }
            extraColumns.forEach((extraColumn, tables) -> {
                if (!this.addExtraColumn4AdditionalEntity(sqlDBModelExtension, (List<ModelColumn>)modelColumns, (String)extraColumn, (List<String>)tables)) {
                    throw new IllegalStateException("Model [" + storage.getModelName() + "] defined an extra column  [" + extraColumn + "]  by @SQLDatabase.ExtraColumn4AdditionalEntity, but couldn't be found from the parent.");
                }
            });
        }
        if (aClass.isAnnotationPresent(BanyanDB.TimestampColumn.class)) {
            String timestampColumn = aClass.getAnnotation(BanyanDB.TimestampColumn.class).value();
            if (StringUtil.isBlank((String)timestampColumn)) {
                throw new IllegalStateException("Model[" + storage.getModelName() + "] missing defined @BanyanDB.TimestampColumn");
            }
            banyanDBModelExtension.setTimestampColumn(timestampColumn);
        }
        if (aClass.isAnnotationPresent(BanyanDB.Trace.TraceIdColumn.class)) {
            String traceIdColumn = aClass.getAnnotation(BanyanDB.Trace.TraceIdColumn.class).value();
            if (StringUtil.isBlank((String)traceIdColumn)) {
                throw new IllegalStateException("Model[trace." + storage.getModelName() + "] missing defined @BanyanDB.TraceIdColumn");
            }
            banyanDBModelExtension.setTraceIdColumn(traceIdColumn);
        }
        if (aClass.isAnnotationPresent(BanyanDB.Trace.SpanIdColumn.class)) {
            String spanIdColumn = aClass.getAnnotation(BanyanDB.Trace.SpanIdColumn.class).value();
            if (StringUtil.isBlank((String)spanIdColumn)) {
                throw new IllegalStateException("Model[trace." + storage.getModelName() + "] missing defined @BanyanDB.SpanIdColumn");
            }
            banyanDBModelExtension.setSpanIdColumn(spanIdColumn);
        }
        if (aClass.isAnnotationPresent(BanyanDB.Trace.TraceIdColumn.class) || aClass.isAnnotationPresent(BanyanDB.Trace.IndexRule.List.class)) {
            ArrayList<BanyanDBModelExtension.TraceIndexRule> traceIndexRules = new ArrayList<BanyanDBModelExtension.TraceIndexRule>();
            if (aClass.isAnnotationPresent(BanyanDB.Trace.IndexRule.class)) {
                BanyanDB.Trace.IndexRule indexRule = aClass.getAnnotation(BanyanDB.Trace.IndexRule.class);
                traceIndexRules.add(this.createTraceIndexRule(aClass, indexRule));
            }
            if (aClass.isAnnotationPresent(BanyanDB.Trace.IndexRule.List.class)) {
                BanyanDB.Trace.IndexRule.List indexRules = aClass.getAnnotation(BanyanDB.Trace.IndexRule.List.class);
                for (BanyanDB.Trace.IndexRule indexRule : indexRules.value()) {
                    traceIndexRules.add(this.createTraceIndexRule(aClass, indexRule));
                }
            }
            banyanDBModelExtension.setTraceIndexRules(traceIndexRules);
        }
        if (aClass.isAnnotationPresent(BanyanDB.IndexMode.class)) {
            banyanDBModelExtension.setIndexMode(true);
        }
        if (aClass.isAnnotationPresent(BanyanDB.Group.class)) {
            BanyanDB.Group group = aClass.getAnnotation(BanyanDB.Group.class);
            banyanDBModelExtension.setStreamGroup(group.streamGroup());
            if (!group.traceGroup().equals((Object)BanyanDB.TraceGroup.NONE)) {
                banyanDBModelExtension.setTraceGroup(group.traceGroup());
            }
        }
        elasticSearchModelExtension.setRouting(storage.getModelName(), modelColumns);
        seriesIDChecker.check(storage.getModelName());
        shardingKeyChecker.check(storage.getModelName());
        Model model = new Model(storage.getModelName(), modelColumns, scopeId, storage.getDownsampling(), this.isSuperDatasetModel(aClass), aClass, storage.isTimeRelativeID(), sqlDBModelExtension, banyanDBModelExtension, elasticSearchModelExtension);
        this.followColumnNameRules(model);
        this.models.add(model);
        for (ModelCreator.CreatingListener listener : this.listeners) {
            listener.whenCreating(model);
        }
        return model;
    }

    private boolean isSuperDatasetModel(Class<?> aClass) {
        return aClass.isAnnotationPresent(SuperDataset.class);
    }

    @Override
    public void addModelListener(ModelCreator.CreatingListener listener) throws StorageException {
        this.listeners.add(listener);
        for (Model model : this.models) {
            listener.whenCreating(model);
        }
    }

    private void retrieval(Class<?> clazz, String modelName, List<ModelColumn> modelColumns, int scopeId, SeriesIDChecker seriesIDChecker, ShardingKeyChecker shardingKeyChecker, SQLDatabaseModelExtension sqlDBModelExtension, BanyanDBModelExtension banyanDBModelExtension) {
        Field[] fields;
        if (log.isDebugEnabled()) {
            log.debug("Analysis {} to generate Model.", (Object)clazz.getName());
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            if (field.isAnnotationPresent(SQLDatabase.AdditionalEntity.class) && !Record.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("Model [" + modelName + "] is not a Record, @SQLDatabase.AdditionalEntity only supports Record.");
            }
            Column column = field.getAnnotation(Column.class);
            int columnLength = column.length();
            SQLDatabaseExtension sqlDatabaseExtension = new SQLDatabaseExtension();
            ArrayList<SQLDatabase.CompositeIndex> indexDefinitions = new ArrayList<SQLDatabase.CompositeIndex>();
            if (field.isAnnotationPresent(SQLDatabase.CompositeIndex.class)) {
                indexDefinitions.add(field.getAnnotation(SQLDatabase.CompositeIndex.class));
            }
            if (field.isAnnotationPresent(SQLDatabase.CompositeIndices.class)) {
                Collections.addAll(indexDefinitions, field.getAnnotation(SQLDatabase.CompositeIndices.class).value());
            }
            indexDefinitions.forEach(indexDefinition -> sqlDatabaseExtension.appendIndex(new SQLDatabaseExtension.MultiColumnsIndex(column.name(), indexDefinition.withColumns())));
            ElasticSearch.MatchQuery elasticSearchAnalyzer = field.getAnnotation(ElasticSearch.MatchQuery.class);
            ElasticSearch.Column elasticSearchColumn = field.getAnnotation(ElasticSearch.Column.class);
            ElasticSearch.Keyword keywordColumn = field.getAnnotation(ElasticSearch.Keyword.class);
            ElasticSearch.Routing routingColumn = field.getAnnotation(ElasticSearch.Routing.class);
            ElasticSearch.EnableDocValues enableDocValues = field.getAnnotation(ElasticSearch.EnableDocValues.class);
            ElasticSearchExtension elasticSearchExtension = new ElasticSearchExtension(elasticSearchAnalyzer == null ? null : elasticSearchAnalyzer.analyzer(), elasticSearchColumn == null ? null : elasticSearchColumn.legacyName(), keywordColumn != null, routingColumn != null, enableDocValues != null);
            BanyanDB.SeriesID banyanDBSeriesID = field.getAnnotation(BanyanDB.SeriesID.class);
            BanyanDB.ShardingKey banyanDBShardingKey = field.getAnnotation(BanyanDB.ShardingKey.class);
            BanyanDB.NoIndexing banyanDBNoIndex = field.getAnnotation(BanyanDB.NoIndexing.class);
            BanyanDB.IndexRule banyanDBIndexRule = field.getAnnotation(BanyanDB.IndexRule.class);
            BanyanDB.MeasureField banyanDBMeasureField = field.getAnnotation(BanyanDB.MeasureField.class);
            BanyanDB.MatchQuery analyzer = field.getAnnotation(BanyanDB.MatchQuery.class);
            BanyanDB.EnableSort enableSort = field.getAnnotation(BanyanDB.EnableSort.class);
            boolean shouldIndex = banyanDBNoIndex == null && !column.storageOnly();
            BanyanDBExtension banyanDBExtension = new BanyanDBExtension(banyanDBSeriesID == null ? -1 : banyanDBSeriesID.index(), banyanDBShardingKey == null ? -1 : banyanDBShardingKey.index(), shouldIndex, banyanDBIndexRule == null ? BanyanDB.IndexRule.IndexType.INVERTED : banyanDBIndexRule.indexType(), banyanDBMeasureField != null, analyzer == null ? null : analyzer.analyzer(), enableSort != null);
            ModelColumn modelColumn = new ModelColumn(new ColumnName(column), field.getType(), field.getGenericType(), column.storageOnly(), column.indexOnly(), column.dataType().isValue(), columnLength, sqlDatabaseExtension, elasticSearchExtension, banyanDBExtension);
            if (banyanDBExtension.isSeriesID()) {
                seriesIDChecker.accept(modelName, modelColumn);
            }
            if (banyanDBExtension.isShardingKey()) {
                shardingKeyChecker.accept(modelName, modelColumn);
            }
            if (field.isAnnotationPresent(SQLDatabase.AdditionalEntity.class)) {
                String[] additionalTableNames;
                SQLDatabase.AdditionalEntity additionalEntity = field.getAnnotation(SQLDatabase.AdditionalEntity.class);
                for (String tableName : additionalTableNames = additionalEntity.additionalTables()) {
                    sqlDBModelExtension.appendAdditionalTable(tableName, modelColumn);
                }
                if (!additionalEntity.reserveOriginalColumns()) {
                    sqlDBModelExtension.appendExcludeColumns(modelColumn);
                }
            }
            modelColumns.add(modelColumn);
            if (log.isDebugEnabled()) {
                log.debug("The field named [{}] with the [{}] type", (Object)column.name(), field.getType());
            }
            if (!column.dataType().isValue()) continue;
            ValueColumnMetadata.INSTANCE.putIfAbsent(modelName, column.name(), column.dataType(), column.defaultValue(), scopeId, column.multiIntValues());
        }
        if (Objects.nonNull(clazz.getSuperclass())) {
            this.retrieval(clazz.getSuperclass(), modelName, modelColumns, scopeId, seriesIDChecker, shardingKeyChecker, sqlDBModelExtension, banyanDBModelExtension);
        }
    }

    @Override
    public void overrideColumnName(String columnName, String newName) {
        this.columnNameOverrideRule.put(columnName, newName);
        this.models.forEach(this::followColumnNameRules);
        ValueColumnMetadata.INSTANCE.overrideColumnName(columnName, newName);
    }

    private void followColumnNameRules(Model model) {
        this.columnNameOverrideRule.forEach((oldName, newName) -> model.getColumns().forEach(column -> {
            log.debug("Override model column name: [{}] {} -> {}.", new Object[]{model.getName(), oldName, newName});
            column.getColumnName().overrideName((String)oldName, (String)newName);
            column.getSqlDatabaseExtension().getIndices().forEach(extraQueryIndex -> extraQueryIndex.overrideName((String)oldName, (String)newName));
        }));
    }

    private boolean addExtraColumn4AdditionalEntity(SQLDatabaseModelExtension sqlDBModelExtension, List<ModelColumn> modelColumns, String extraColumn, List<String> additionalTables) {
        for (ModelColumn modelColumn : modelColumns) {
            if (!modelColumn.getColumnName().getName().equals(extraColumn)) continue;
            additionalTables.forEach(tableName -> sqlDBModelExtension.appendAdditionalTable((String)tableName, modelColumn));
            return true;
        }
        return false;
    }

    @Override
    public List<Model> allModels() {
        return this.models;
    }

    private BanyanDBModelExtension.TraceIndexRule createTraceIndexRule(Class<?> aClass, BanyanDB.Trace.IndexRule indexRuleColumns) {
        String name = indexRuleColumns.name();
        String[] columns = indexRuleColumns.columns();
        String orderBy = indexRuleColumns.orderByColumn();
        if (Objects.isNull(name) || Objects.isNull(columns) || columns.length == 0 || Objects.isNull(orderBy)) {
            throw new IllegalArgumentException("The @BanyanDB.Trace.IndexRuleColumns of " + aClass.getName() + " has invalid definition.");
        }
        return new BanyanDBModelExtension.TraceIndexRule(name, columns, orderBy);
    }

    private static class SeriesIDChecker {
        private final ArrayList<ModelColumn> keys = new ArrayList();

        private SeriesIDChecker() {
        }

        private void accept(String modelName, ModelColumn modelColumn) throws IllegalStateException {
            int idx = modelColumn.getBanyanDBExtension().getSeriesIDIdx();
            while (idx + 1 > this.keys.size()) {
                this.keys.add(null);
            }
            ModelColumn exist = this.keys.get(idx);
            if (exist != null) {
                throw new IllegalStateException(modelName + "'s Column [" + String.valueOf(exist.getColumnName()) + "] and column [" + String.valueOf(modelColumn.getColumnName()) + " are conflicting with seriesID index=" + modelColumn.getBanyanDBExtension().getSeriesIDIdx());
            }
            this.keys.set(idx, modelColumn);
        }

        private void check(String modelName) throws IllegalStateException {
            for (int i = 0; i < this.keys.size(); ++i) {
                ModelColumn modelColumn = this.keys.get(i);
                if (modelColumn != null) continue;
                throw new IllegalStateException("seriesID index=" + i + " is missing in " + modelName);
            }
        }
    }

    private static class ShardingKeyChecker {
        private final ArrayList<ModelColumn> keys = new ArrayList();

        private ShardingKeyChecker() {
        }

        private void accept(String modelName, ModelColumn modelColumn) throws IllegalStateException {
            int idx = modelColumn.getBanyanDBExtension().getShardingKeyIdx();
            while (idx + 1 > this.keys.size()) {
                this.keys.add(null);
            }
            ModelColumn exist = this.keys.get(idx);
            if (exist != null) {
                throw new IllegalStateException(modelName + "'s Column [" + String.valueOf(exist.getColumnName()) + "] and column [" + String.valueOf(modelColumn.getColumnName()) + " are conflicting with sharding key index=" + modelColumn.getBanyanDBExtension().getShardingKeyIdx());
            }
            this.keys.set(idx, modelColumn);
        }

        private void check(String modelName) throws IllegalStateException {
            for (int i = 0; i < this.keys.size(); ++i) {
                ModelColumn modelColumn = this.keys.get(i);
                if (modelColumn != null) continue;
                throw new IllegalStateException("sharding key index=" + i + " is missing in " + modelName);
            }
        }
    }
}

